# バッチ設計書 39-messenger:failed:show

## 概要

本ドキュメントは、Symfony Messengerコンポーネントが提供する `messenger:failed:show` コマンドのバッチ設計書である。失敗トランスポートに蓄積されたメッセージの一覧表示および個別メッセージの詳細表示を行う運用管理コマンドの仕様を定義する。

### 本バッチの処理概要

`messenger:failed:show` コマンドは、失敗トランスポートに保存されている処理失敗メッセージを一覧表示または個別表示するコマンドである。

**業務上の目的・背景**：非同期メッセージ処理において、ハンドラで例外が発生しリトライ上限に達したメッセージは失敗トランスポートに移動される。運用者はこれらの失敗メッセージの内容とエラー原因を確認し、リトライまたは削除の判断を行う必要がある。本コマンドはこの確認作業を支援し、失敗メッセージの管理を効率化する。

**バッチの実行タイミング**：随時実行（手動）。運用監視やトラブルシューティング時に使用する。

**主要な処理内容**：
1. 失敗トランスポートの選択（デフォルトまたは指定）
2. 保留中メッセージ数の表示
3. モード判定（一覧表示 / 統計表示 / 個別表示）
4. メッセージ情報の取得と整形出力

**前後の処理との関連**：`messenger:consume` で処理に失敗し失敗トランスポートに移動されたメッセージが対象。確認後、`messenger:failed:retry` でリトライまたは `messenger:failed:remove` で削除する。

**影響範囲**：読み取り専用のメッセージ表示処理であり、メッセージキューやシステム状態を変更しない。

## バッチ種別

運用管理（失敗メッセージ確認）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 失敗トランスポート | 少なくとも1つの失敗トランスポートが設定されていること |
| ListableReceiverInterface | 失敗トランスポートがListableReceiverInterfaceを実装していること |

### 実行可否判定

失敗トランスポートが設定され、ListableReceiverInterfaceを実装している場合に実行可能。非実装の場合はRuntimeExceptionが発生する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| id | string | No | なし | 表示する特定メッセージのID |
| --max | int | No | 50 | 一覧表示の最大件数 |
| --transport | string | No | choose（デフォルトトランスポート） | 使用する失敗トランスポート名 |
| --stats | bool | No | false | クラス別のメッセージ件数を表示 |
| --class-filter | string | No | なし | 特定クラスでフィルタリング |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 失敗トランスポート | ListableReceiverInterface | 失敗メッセージの取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| STDOUT | テキスト | メッセージ一覧テーブル / 統計テーブル / 個別メッセージ詳細 |
| STDERR | テキスト | 警告・ノート・操作ガイダンス |

### 出力ファイル仕様

ファイル出力は行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし（標準出力） |
| 出力先 | STDOUT |
| 文字コード | UTF-8 |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. コマンド初期化
   └─ 引数・オプションの取得
2. 失敗トランスポート選択
   ├─ --transport指定時: 指定トランスポート
   ├─ 複数失敗トランスポート存在時: 対話的選択または警告表示
   └─ デフォルト: グローバル失敗トランスポート
3. レシーバー取得・保留メッセージ数表示
4. ListableReceiverInterface実装チェック
5. モード判定・実行
   ├─ --stats指定: クラス別メッセージ件数テーブル表示
   ├─ id引数なし: メッセージ一覧テーブル表示
   │   ├─ --class-filter適用
   │   ├─ Id, Class, Failed at, Error列のテーブル
   │   └─ 操作ガイダンス出力
   └─ id引数あり: 個別メッセージ詳細表示
       ├─ メッセージクラス、ID、失敗日時、エラー情報
       ├─ メッセージ履歴（redelivery stamps）
       ├─ メッセージ内容（-vv指定時）
       └─ retry / remove コマンドの案内
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[失敗トランスポート選択]
    B --> C[レシーバー取得]
    C --> D[保留メッセージ数表示]
    D --> E{ListableReceiver?}
    E -->|非実装| F[RuntimeException]
    E -->|実装あり| G{表示モード}
    G -->|--stats| H[クラス別統計表示]
    G -->|id引数なし| I[メッセージ一覧表示]
    G -->|id引数あり| J[個別メッセージ表示]
    I --> K[テーブル出力]
    J --> L[詳細情報出力]
    H --> M[バッチ終了]
    K --> M
    L --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンド自体はデータベースの変更操作を行わないが、失敗トランスポートがDoctrineの場合はSELECTクエリが実行される。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| メッセージ一覧取得 | messenger_messages（Doctrine使用時） | SELECT | 失敗メッセージの取得 |
| メッセージ個別取得 | messenger_messages（Doctrine使用時） | SELECT | 指定IDのメッセージ取得 |
| メッセージ件数取得 | messenger_messages（Doctrine使用時） | SELECT COUNT | 保留メッセージ数カウント |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RuntimeException | 失敗トランスポートがListableReceiverInterface非実装 | 対応するトランスポートに変更する |
| - | RuntimeException | 指定IDのメッセージが見つからない | 正しいIDを指定する |
| - | InvalidArgumentException | 失敗トランスポートが存在しない | 正しいトランスポート名を指定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

失敗トランスポートへの接続に失敗した場合は、接続情報を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | --maxで制限（デフォルト50件） |
| 目標処理時間 | 即時 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

排他制御なし。読み取り専用の処理であり、同時実行しても問題ない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| メッセージ一覧 | 一覧表示時 | Id, Class, Failed at, Error列のテーブル |
| 統計情報 | --stats指定時 | Class, Count列のテーブル |
| 詳細情報 | 個別表示時 | メッセージ詳細（クラス、ID、エラー情報、メッセージ履歴） |
| 成功ログ | 失敗メッセージ0件時 | 「No failed messages were found.」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 失敗メッセージ数 | 環境依存 | 監視システム |

## 備考

- 基盤実装は `src/Symfony/Component/Messenger/Command/FailedMessagesShowCommand.php` に存在する
- AbstractFailedMessagesCommandを継承し、共通の失敗メッセージ表示機能を利用する
- PhpSerializerが設定されている場合、acceptPhpIncompleteClass()により不完全なクラスのデシリアライズを許容する
- -vvオプションでメッセージの内容と例外の詳細をダンプ表示できる
- 個別メッセージ表示時にretryコマンドとremoveコマンドの実行例が案内される
- --class-filterオプションで特定クラスのメッセージのみをフィルタリング表示可能
- --statsオプションでクラス別の失敗メッセージ件数を確認可能
- 複数の失敗トランスポートが存在する場合、対話的にトランスポートを選択可能
