# バッチ設計書 4-cache:pool:delete

## 概要

本ドキュメントは、Symfonyフレームワークが提供する `cache:pool:delete` コンソールコマンドのバッチ設計書である。指定されたキャッシュプールから特定のキャッシュアイテムを削除する処理の仕様を定義する。

### 本バッチの処理概要

`cache:pool:delete` コマンドは、PSR-6準拠のキャッシュプールから特定のキーに対応するキャッシュアイテムを1件削除する機能を提供する。プール全体のクリアではなく、ピンポイントでのキャッシュ削除を行う。

**業務上の目的・背景**：キャッシュプール全体をクリアするのではなく、特定のキャッシュエントリのみを無効化したい場合に使用する。例えば、特定ユーザーのキャッシュデータが破損した場合や、特定のリソースのキャッシュを個別に更新したい場合に有用である。プール全体のクリアに伴うパフォーマンス低下を回避しつつ、必要な箇所のみをリフレッシュできるため、運用時のきめ細やかなキャッシュ管理を実現する。

**バッチの実行タイミング**：特定のキャッシュアイテムが不正な状態になった場合、データ修正後に特定キャッシュのみをリフレッシュしたい場合など、随時手動で実行される。

**主要な処理内容**：
1. 引数からプール名とキャッシュキーを取得
2. Psr6CacheClearerからプール名に対応するキャッシュプールインスタンスを取得
3. 指定キーのアイテムが存在するか `hasItem()` で確認
4. アイテムが存在しない場合はnoteメッセージを出力して正常終了
5. アイテムが存在する場合は `deleteItem()` で削除
6. 削除に失敗した場合は例外をスロー

**前後の処理との関連**：`cache:pool:list` コマンドで利用可能なプール名を確認してから実行する。`cache:pool:clear` とは異なり、プール全体ではなく個別のアイテムを対象とする。

**影響範囲**：指定されたキャッシュプール内の1つのキャッシュアイテムのみが影響を受ける。他のキャッシュアイテムには影響しない。

## バッチ種別

キャッシュ管理 / メンテナンスコマンド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| プール名の指定 | 必須引数としてプール名を指定する |
| キャッシュキーの指定 | 必須引数としてキャッシュキーを指定する |
| プールの存在 | 指定プール名がPsr6CacheClearerに登録されている必要がある |

### 実行可否判定

プール名とキャッシュキーの両方が必須引数として指定されている必要がある。未指定の場合はSymfony Consoleフレームワークによりエラーが返される。指定されたプール名がPsr6CacheClearerに登録されていない場合は、`getPool()` メソッドで例外がスローされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| pool | string | Yes | なし | キャッシュアイテムを削除するプール名 |
| key | string | Yes | なし | 削除対象のキャッシュキー |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Psr6CacheClearer | サービス | キャッシュプール取得用サービス |
| poolNames | 配列 | シェル補完用のプール名リスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stdout | テキスト | 削除結果メッセージ（成功/存在しない/エラー） |

### 出力ファイル仕様

該当なし

## 処理フロー

### 処理シーケンス

```
1. 引数取得
   └─ pool名とkeyを取得
2. プールインスタンス取得
   └─ Psr6CacheClearerからプール名に対応するCacheItemPoolを取得
3. アイテム存在確認
   └─ hasItem()でキーの存在を確認
4. 存在しない場合
   └─ noteメッセージを出力して終了コード0で終了
5. アイテム削除
   └─ deleteItem()でキャッシュアイテムを削除
6. 削除失敗時
   └─ Exceptionをスロー
7. 削除成功時
   └─ 成功メッセージを出力して終了コード0で終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[pool名とkey取得]
    B --> C[プールインスタンス取得]
    C --> D{hasItem でアイテム存在確認}
    D -->|存在しない| E[noteメッセージ出力]
    D -->|存在する| F[deleteItem でアイテム削除]
    E --> G[終了コード0]
    F --> H{削除成功?}
    H -->|Yes| I[成功メッセージ出力]
    H -->|No| J[Exception スロー]
    I --> G
    G --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースに対する直接的な操作を行わない。キャッシュバックエンドとしてデータベースが使用されている場合は、対応するレコードが削除される可能性がある。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | キャッシュバックエンド依存 |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Exception | 削除失敗 | `deleteItem()` がfalseを返した場合 | プールの実装・設定・バックエンドの状態を確認する |
| InvalidArgumentException | プール不在 | 指定プール名がPsr6CacheClearerに未登録 | 正しいプール名を指定する（cache:pool:listで確認） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 削除に失敗した場合、キャッシュバックエンド（Redis、Memcached、ファイルシステム等）の状態を確認する。
2. アイテムが存在しない場合は正常終了扱いとなるため、エラーとはならない。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 単一アイテムの削除操作 |
| コミットタイミング | deleteItem()完了時 |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（単一アイテム） |
| 目標処理時間 | ミリ秒単位（即座に完了） |
| メモリ使用量上限 | 最小限 |

## 排他制御

単一アイテムの削除操作であるため、排他制御はキャッシュバックエンドの実装に依存する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | アイテム不在時 | `Cache item "{key}" does not exist in cache pool "{pool}".` |
| 終了ログ | 削除成功時 | `Cache item "{key}" was successfully deleted.` |
| エラーログ | 削除失敗時 | `Cache item "{key}" could not be deleted.` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 運用監視システム |

## 備考

- シェル補完機能をサポートしており、プール名の入力時に候補が表示される。
- アイテムが存在しない場合でも終了コードは0（成功）が返される。これはべき等性を持つ設計である。
- ソースコード: `src/Symfony/Bundle/FrameworkBundle/Command/CachePoolDeleteCommand.php`
