# バッチ設計書 41-messenger:failed:remove

## 概要

本ドキュメントは、Symfony Messengerコンポーネントの `messenger:failed:remove` コマンドのバッチ設計書である。失敗トランスポートに蓄積されたメッセージを指定して削除するためのコンソールコマンドについて、処理フロー、入出力仕様、エラー処理等を定義する。

### 本バッチの処理概要

`messenger:failed:remove` コマンドは、Symfony Messengerの失敗トランスポート（failure transport）に蓄積された処理失敗メッセージを、指定されたID、クラスフィルタ、または全件一括で削除する運用コマンドである。

**業務上の目的・背景**：Symfony Messengerでは、メッセージの処理に失敗した場合に失敗トランスポートへメッセージが退避される。時間の経過とともにリトライ不要なメッセージが蓄積し、ストレージの圧迫や運用上の混乱を招く。本コマンドは、不要な失敗メッセージを安全に削除し、失敗トランスポートの衛生状態を維持するために必要である。`messenger:failed:show` で確認した後、リトライ不要と判断されたメッセージを削除する運用フローの一環として使用される。

**バッチの実行タイミング**：随時（手動実行）。運用担当者が失敗メッセージを確認した後に実行する。定期的なクリーンアップとしてcronジョブで `--all --force` オプション付きで実行することも可能である。

**主要な処理内容**：
1. 失敗トランスポートの取得とバリデーション（ListableReceiverInterface実装の確認）
2. 削除対象メッセージの特定（ID指定、クラスフィルタ、または全件）
3. 確認プロンプトの表示（forceオプション未指定時）
4. 対象メッセージの削除（receiver.reject()による永久削除）
5. 削除結果の出力

**前後の処理との関連**：`messenger:failed:show` コマンドで失敗メッセージの内容を確認した後に実行される。`messenger:failed:retry` コマンドでリトライ可能なメッセージを再処理した後、残りの不要メッセージを削除する用途で使用される。

**影響範囲**：失敗トランスポートに格納されたメッセージデータに影響する。削除されたメッセージは復元不可能であり、データベースベースのトランスポートの場合は対応するレコードが物理削除される。

## バッチ種別

データクレンジング / 運用メンテナンス

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / cron（定期クリーンアップ時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 失敗トランスポートの設定 | `framework.messenger.failure_transport` または個別のfailure transportが設定されていること |
| ListableReceiverInterface | 失敗トランスポートのreceiverがListableReceiverInterfaceを実装していること |
| メッセージの存在 | 削除対象のメッセージが失敗トランスポートに存在すること |

### 実行可否判定

- `--all` オプションと `id` 引数が同時に指定された場合はRuntimeExceptionで実行不可
- `--all` オプションも `id` 引数も `--class-filter` オプションも指定されていない場合はRuntimeExceptionで実行不可
- 失敗トランスポートのreceiverがListableReceiverInterfaceを実装していない場合はRuntimeExceptionで実行不可

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| id | array (string) | No | なし | 削除対象メッセージのID（複数指定可） |
| --all | bool | No | false | 全メッセージを削除する |
| --force | bool | No | false | 確認プロンプトをスキップして強制実行する |
| --transport | string | No | 'choose' | 使用する失敗トランスポート名 |
| --show-messages | bool | No | false | 削除前にメッセージ内容を表示する（複数ID指定時） |
| --class-filter | string | No | null | 指定クラス名でフィルタして削除対象を抽出する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 失敗トランスポート | Messengerトランスポート | ServiceProviderInterfaceを通じて取得される失敗トランスポート |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール（stdout） | テキスト | 削除成功メッセージ |
| コンソール（stderr） | テキスト | エラーメッセージ、確認プロンプト、スキップ通知 |

### 出力ファイル仕様

ファイル出力なし。コンソール出力のみ。

## 処理フロー

### 処理シーケンス

```
1. 失敗トランスポートの解決
   └─ --transportオプションで指定されたトランスポート名を解決。未指定の場合はグローバル失敗トランスポートを使用
2. Receiverの取得とバリデーション
   └─ ServiceProviderからreceiverを取得し、ListableReceiverInterfaceの実装を確認
3. 削除モードの判定
   ├─ --class-filterが指定されている場合: クラスフィルタでメッセージIDを抽出
   ├─ --allが指定されている場合: 全件削除モード
   └─ id引数が指定されている場合: ID指定削除モード
4. メッセージの削除実行
   ├─ 全件削除: receiver.all()で全メッセージを取得し、各メッセージに対してreceiver.reject()を実行
   └─ ID指定削除: 各IDに対してreceiver.find()でメッセージを取得し、receiver.reject()を実行
5. 結果の出力
   └─ 削除件数またはメッセージごとの削除結果を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[失敗トランスポート解決]
    B --> C[Receiver取得]
    C --> D{ListableReceiver?}
    D -->|No| E[RuntimeException]
    D -->|Yes| F{class-filter指定?}
    F -->|Yes| G[クラスフィルタでID抽出]
    G --> H{該当メッセージあり?}
    H -->|No| I[RuntimeException]
    H -->|Yes| J{確認プロンプト}
    F -->|No| K{--all指定?}
    K -->|Yes| L[全件削除モード]
    K -->|No| M{id指定?}
    M -->|No| N[RuntimeException]
    M -->|Yes| O[ID指定削除モード]
    J -->|Yes| O
    J -->|No| P[終了 code=0]
    L --> Q{force or 確認?}
    Q -->|Yes| R[全メッセージ削除実行]
    Q -->|No| P
    O --> S[各メッセージを削除]
    R --> T[削除件数出力]
    S --> U[削除結果出力]
    T --> P
    U --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| メッセージ削除 | トランスポート依存（例: messenger_messages） | DELETE | receiver.reject()を通じて失敗メッセージを物理削除 |
| メッセージ検索 | トランスポート依存（例: messenger_messages） | SELECT | receiver.find()またはreceiver.all()でメッセージを取得 |

### テーブル別操作詳細

#### messenger_messages（トランスポート依存）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | id指定またはqueue_name条件 | find()またはall()メソッド経由 |
| DELETE | - | 対象メッセージのID | reject()メソッド経由で物理削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RuntimeException | ReceiverがListableReceiverInterfaceを未実装 | ListableReceiverInterfaceを実装するトランスポートに変更 |
| - | RuntimeException | IDも--allも未指定 | IDを指定するか--allオプションを付与 |
| - | RuntimeException | --allとIDが同時に指定 | いずれか一方のみ指定 |
| - | RuntimeException | class-filterで該当メッセージなし | フィルタ条件を確認 |
| - | エラー出力 | 指定IDのメッセージが見つからない | 正しいIDを指定（messenger:failed:showで確認） |
| - | InvalidArgumentException | 失敗トランスポートが見つからない | トランスポート設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（単発実行） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

本コマンドはメッセージ単位で削除を行うため、処理途中でエラーが発生した場合は、未処理のメッセージは削除されずに残る。再度コマンドを実行することで継続可能である。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | メッセージ単位（各reject()呼び出し単位） |
| コミットタイミング | 各メッセージの削除完了時 |
| ロールバック条件 | トランスポート実装依存 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数件〜数千件（失敗メッセージの蓄積量に依存） |
| 目標処理時間 | トランスポート実装とメッセージ件数に依存 |
| メモリ使用量上限 | --allオプション使用時は全メッセージをイテレーションするため注意が必要 |

## 排他制御

同時実行の制御は行われていない。複数プロセスから同時に実行した場合、同一メッセージに対する競合が発生する可能性がある。運用上、同一トランスポートに対する同時実行は避けることが推奨される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 成功メッセージ | 各メッセージ削除成功時 | "Message with id {id} removed." |
| スキップ通知 | ユーザーが削除を拒否した時 | "Message with id {id} not removed." |
| エラーメッセージ | メッセージが見つからない時 | "The message with id {id} was not found." |
| 全件削除結果 | 全件削除完了時 | "{count} messages were removed." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

本コマンドは手動実行が基本であり、特定の監視・アラートは設定されていない。定期実行する場合は、実行結果のリターンコードを監視することが推奨される。

## 備考

- 削除されたメッセージは復元不可能であるため、`messenger:failed:show` で内容を確認してから実行することが推奨される
- PhpSerializerが設定されている場合、acceptPhpIncompleteClass/rejectPhpIncompleteClassによる不完全クラスの処理が行われる
- `--class-filter` オプションを使用すると、特定のメッセージクラスに絞って一括削除が可能
- リターンコードは常に0（成功）を返す
