# バッチ設計書 42-debug:messenger

## 概要

本ドキュメントは、Symfony Messengerコンポーネントの `debug:messenger` コマンドのバッチ設計書である。メッセージバスに登録されたメッセージとそのハンドラのマッピング情報をデバッグ用途で一覧表示するコンソールコマンドについて、処理フロー、入出力仕様、エラー処理等を定義する。

### 本バッチの処理概要

`debug:messenger` コマンドは、Symfony Messengerのメッセージバスにディスパッチ可能なメッセージクラスと、それらを処理するハンドラの一覧を表示するデバッグコマンドである。

**業務上の目的・背景**：Symfony Messengerでは、メッセージバスを通じてメッセージとハンドラがマッピングされるが、設定が複雑になるとどのメッセージがどのハンドラで処理されるか把握が困難になる。本コマンドは、開発者がメッセージとハンドラの関係を迅速に確認し、設定ミスや欠落を検出するために使用される。複数のメッセージバスが存在する場合に、各バスのマッピングを個別に確認できる点が重要である。

**バッチの実行タイミング**：随時（手動実行）。開発時やデバッグ時に開発者が必要に応じて実行する。

**主要な処理内容**：
1. メッセージバスとハンドラのマッピング情報の取得
2. 指定バスのフィルタリング（バス名が指定された場合）
3. バスごとのメッセージ・ハンドラ一覧のテーブル表示
4. メッセージクラスのDocComment（説明文）の抽出と表示

**前後の処理との関連**：独立したデバッグコマンドであり、前後の処理依存はない。`debug:event-dispatcher` や `debug:container` と同様の診断コマンド群の一つ。

**影響範囲**：読み取り専用コマンドであり、システム状態に影響を与えない。コンソール出力のみ。

## バッチ種別

デバッグ / 診断ツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Messengerコンポーネント | Symfony Messengerコンポーネントがインストール・設定されていること |
| メッセージバスの設定 | 少なくとも1つのメッセージバスが設定されていること |

### 実行可否判定

- 指定されたバス名がマッピングに存在しない場合はRuntimeExceptionで実行不可
- マッピング情報が空（ハンドラ未登録）の場合も実行可能だが、警告メッセージを表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| bus | string | No | null（全バス表示） | 表示対象のバスID |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| メッセージバスマッピング | PHP配列（DIコンテナ注入） | バス名をキー、メッセージ・ハンドラのマッピングを値とする配列 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール（stdout） | テーブル形式テキスト | バスごとのメッセージ・ハンドラ一覧 |

### 出力ファイル仕様

ファイル出力なし。コンソール出力のみ。

## 処理フロー

### 処理シーケンス

```
1. マッピング情報の取得
   └─ コンストラクタで注入されたメッセージ・ハンドラのマッピング配列を使用
2. バスフィルタの適用
   └─ bus引数が指定された場合、該当バスのマッピングのみに絞り込む
3. バスごとの一覧表示
   ├─ バス名をセクション見出しとして表示
   ├─ 各メッセージクラスのDocCommentを取得・表示
   ├─ 各メッセージクラス名を色付きで表示
   ├─ 各ハンドラ名と条件（options）を表示
   └─ ハンドラクラスのDocCommentも表示
4. 空バスの警告
   └─ ハンドラが未登録のバスについて警告メッセージを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[マッピング情報取得]
    B --> C{bus引数指定?}
    C -->|Yes| D{バスが存在?}
    D -->|No| E[RuntimeException]
    D -->|Yes| F[対象バスのみ抽出]
    C -->|No| G[全バスを対象]
    F --> H[バスごとにループ]
    G --> H
    H --> I{メッセージあり?}
    I -->|Yes| J[メッセージ・ハンドラをテーブル表示]
    I -->|No| K[警告表示]
    J --> L{次のバスあり?}
    K --> L
    L -->|Yes| H
    L -->|No| M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。本コマンドはDIコンテナに注入されたマッピング情報のみを参照する読み取り専用コマンドである。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RuntimeException | 指定バス名が存在しない | 正しいバス名を指定（存在するバス名は例外メッセージに表示される） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（単発実行） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

デバッグコマンドであるため、障害時の特別な対応は不要。エラーメッセージに従いパラメータを修正して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | マッピングに登録されたメッセージ・ハンドラの数に依存（通常数十〜数百件） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 特に制限なし（メタデータのみの処理） |

## 排他制御

読み取り専用コマンドであるため、排他制御は不要。同時実行しても問題は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| タイトル | コマンド実行時 | "Messenger" |
| セクション | 各バス処理時 | バス名 |
| テーブル | メッセージ一覧表示時 | メッセージクラス名、ハンドラ名、条件、説明文 |
| 警告 | ハンドラ未登録時 | "No handled message found in bus {bus}." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

デバッグ用途のため、監視・アラートは設定しない。

## 備考

- ReflectionClassを使用してメッセージクラスとハンドラクラスのDocCommentを取得し、説明文として表示する
- ハンドラのオプション（条件）がある場合は「(when key=value)」形式で表示される
- コンソール補完（CompletionInput）に対応しており、bus引数の候補を自動補完できる
- リターンコードは常に0（成功）を返す
