# バッチ設計書 43-translation:push

## 概要

本ドキュメントは、Symfony Translationコンポーネントの `translation:push` コマンドのバッチ設計書である。ローカルの翻訳ファイルを指定した翻訳プロバイダーにプッシュ（アップロード）するコンソールコマンドについて、処理フロー、入出力仕様、エラー処理等を定義する。

### 本バッチの処理概要

`translation:push` コマンドは、ローカルに存在する翻訳メッセージを外部の翻訳プロバイダー（Crowdin、Loco、Lokalise等）にプッシュするためのコンソールコマンドである。デフォルトでは新規翻訳のみをプッシュし、既存翻訳は上書きしない。

**業務上の目的・背景**：多言語対応のアプリケーション開発において、翻訳管理を外部サービス（翻訳プロバイダー）に委託するケースが増えている。開発者がローカルで作成・更新した翻訳ファイルを翻訳プロバイダーに同期することで、翻訳者との協業を円滑にし、翻訳ワークフローを効率化するために本コマンドが必要である。

**バッチの実行タイミング**：随時（手動実行）。翻訳ファイルの更新後、翻訳プロバイダーとの同期が必要な時に実行する。CI/CDパイプラインに組み込んで自動実行することも可能。

**主要な処理内容**：
1. ローカル翻訳ファイルの読み込み（TranslationReaderInterface経由）
2. プロバイダーの翻訳データの取得（差分比較が必要な場合）
3. 差分計算と同期対象の決定
4. 翻訳データのプロバイダーへのプッシュ（write）
5. 不要翻訳の削除（--delete-missingオプション使用時）

**前後の処理との関連**：`translation:pull` コマンドと対をなすコマンドである。`translation:extract` でコードから翻訳キーを抽出した後に使用されることが多い。

**影響範囲**：外部翻訳プロバイダーの翻訳データに影響する。--forceオプション使用時は既存翻訳が上書きされ、--delete-missingオプション使用時はプロバイダー上の翻訳が削除される。

## バッチ種別

データ連携（外部サービス同期）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 翻訳プロバイダーの設定 | `framework.translator.providers` に翻訳プロバイダーが設定されていること |
| 有効ロケールの設定 | `framework.enabled_locales` または各プロバイダーのlocales設定があること |
| ローカル翻訳ファイル | transPaths配下に翻訳ファイルが存在すること |
| プロバイダーへの接続 | 外部翻訳プロバイダーへのネットワーク接続が可能であること |

### 実行可否判定

- enabledLocalesが空の場合はInvalidArgumentExceptionで実行不可
- 指定されたプロバイダーが存在しない場合はエラー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| provider | string | Yes/No | プロバイダーが1つの場合は自動設定 | プッシュ先の翻訳プロバイダー名 |
| --force | bool | No | false | 既存翻訳をローカルの内容で上書きする |
| --delete-missing | bool | No | false | ローカルに存在しないプロバイダー上の翻訳を削除する |
| --domains | array (string) | No | 全ドメイン | プッシュ対象のドメインを指定 |
| --locales | array (string) | No | enabledLocales | プッシュ対象のロケールを指定 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ローカル翻訳ファイル | XLIFF/YAML/PHP等 | transPaths配下の翻訳ファイル |
| 翻訳プロバイダー | 外部API | プロバイダーの既存翻訳データ（差分計算時に取得） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 翻訳プロバイダー | 外部API | プッシュされた翻訳データ |
| コンソール（stdout） | テキスト | 処理結果メッセージ |

### 出力ファイル仕様

ファイル出力なし。外部プロバイダーへのAPI通信とコンソール出力のみ。

## 処理フロー

### 処理シーケンス

```
1. プロバイダーの取得
   └─ TranslationProviderCollectionからプロバイダーを取得
2. ロケール・ドメインの決定
   ├─ --localesオプションまたはenabledLocalesを使用
   └─ --domainsオプションまたはFilteringProviderのドメインを使用
3. ローカル翻訳の読み込み
   └─ TranslationReaderを使用してtransPaths配下の翻訳ファイルを読み込み
4. 同期処理
   ├─ forceのみ: ローカル翻訳をそのままプロバイダーにwrite
   ├─ delete-missing: プロバイダーの翻訳を取得し、ローカルにないものを削除
   └─ デフォルト: ローカルとプロバイダーの差分を計算し、新規翻訳のみwrite
5. 結果出力
   └─ 成功メッセージをコンソールに出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[プロバイダー取得]
    B --> C{enabledLocales存在?}
    C -->|No| D[InvalidArgumentException]
    C -->|Yes| E[ロケール・ドメイン決定]
    E --> F[ローカル翻訳読み込み]
    F --> G{delete-missing?}
    G -->|Yes| H[プロバイダー翻訳取得]
    H --> I[差分計算・不要翻訳削除]
    I --> J[プロバイダー翻訳再取得]
    G -->|No| K{forceのみ?}
    K -->|Yes| L[ローカル翻訳をwrite]
    K -->|No| M[プロバイダー翻訳取得]
    M --> N[差分計算]
    J --> O{force?}
    O -->|Yes| P[差分+既存翻訳をwrite]
    O -->|No| Q[差分のみwrite]
    N --> R{force?}
    R -->|Yes| S[差分+既存翻訳をwrite]
    R -->|No| T[新規翻訳のみwrite]
    L --> U[成功メッセージ出力]
    P --> U
    Q --> U
    S --> U
    T --> U
    U --> V[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース直接操作なし。外部翻訳プロバイダーへのAPI通信で翻訳データを操作する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidArgumentException | enabledLocalesが未設定 | framework.enabled_localesまたはプロバイダーのlocales設定を追加 |
| - | 例外 | プロバイダーが見つからない | プロバイダー設定を確認 |
| - | ネットワークエラー | プロバイダーへの接続失敗 | ネットワーク接続・認証情報を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（単発実行） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

プロバイダーへの通信エラーが発生した場合は、ネットワーク接続と認証情報を確認の上、再実行する。--delete-missingオプション使用時に途中で失敗した場合、一部の翻訳が削除済みの状態になる可能性があるため、translation:pullで復旧を検討する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | プロバイダーAPI単位（write/delete単位） |
| コミットタイミング | 各API呼び出し完了時 |
| ロールバック条件 | プロバイダー実装依存 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 翻訳メッセージ数に依存（数十〜数万件） |
| 目標処理時間 | プロバイダーのAPI応答時間に依存 |
| メモリ使用量上限 | 全翻訳データをメモリに読み込むため、大量の翻訳がある場合は注意 |

## 排他制御

コマンドレベルでの排他制御は行われていない。同一プロバイダーに対する同時実行は予期しない結果を招く可能性があるため避けることが推奨される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 成功メッセージ | プッシュ完了時 | "All/New local translations has been sent to {provider}..." |
| 削除成功 | delete-missing完了時 | "Missing translations on {provider} has been deleted..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

CI/CDパイプラインで実行する場合は、コマンドのリターンコードを監視することが推奨される。

## 備考

- プロバイダーが1つだけ設定されている場合、provider引数は省略可能（自動的にそのプロバイダーが選択される）
- FilteringProviderの場合、ドメインが未指定でもプロバイダーの設定済みドメインが自動的に使用される
- --forceオプションと--delete-missingオプションは組み合わせ可能で、完全同期を実現する
- TranslationTraitのreadLocalTranslationsメソッドを使用してローカル翻訳を読み込む
- コンソール補完に対応（provider引数、--domainsオプション、--localesオプション）
- リターンコードは常に0（成功）を返す
