# バッチ設計書 44-translation:pull

## 概要

本ドキュメントは、Symfony Translationコンポーネントの `translation:pull` コマンドのバッチ設計書である。外部の翻訳プロバイダーから翻訳データを取得（プル）してローカルの翻訳ファイルに書き込むコンソールコマンドについて、処理フロー、入出力仕様、エラー処理等を定義する。

### 本バッチの処理概要

`translation:pull` コマンドは、外部の翻訳プロバイダー（Crowdin、Loco、Lokalise等）から翻訳メッセージを取得し、ローカルの翻訳ファイルとして書き出すコンソールコマンドである。デフォルトでは新規翻訳のみを追加し、既存のローカル翻訳は上書きしない。

**業務上の目的・背景**：翻訳管理を外部サービスに委託している場合、翻訳者が外部サービス上で更新した翻訳をローカルの開発環境やデプロイ対象のコードベースに反映する必要がある。本コマンドは、翻訳プロバイダーからの翻訳データ取得を自動化し、翻訳ワークフローの効率を高めるために使用される。

**バッチの実行タイミング**：随時（手動実行）。翻訳者が外部プロバイダーで翻訳を更新した後に実行する。CI/CDパイプラインやデプロイスクリプトに組み込んで自動実行することも可能。

**主要な処理内容**：
1. 翻訳プロバイダーからの翻訳データ取得（read）
2. ローカル翻訳ファイルの読み込み（--forceなしの場合の差分計算用）
3. 差分の計算とマージ
4. ローカル翻訳ファイルへの書き込み（TranslationWriterInterface経由）

**前後の処理との関連**：`translation:push` コマンドと対をなすコマンドである。翻訳プロバイダーへプッシュした後、翻訳者が更新した内容をプルして反映するワークフローで使用される。

**影響範囲**：ローカルの翻訳ファイルに影響する。--forceオプション使用時は既存翻訳が上書きされ、プロバイダーにない翻訳キーはローカルファイルから削除される。

## バッチ種別

データ連携（外部サービス同期）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 翻訳プロバイダーの設定 | `framework.translator.providers` に翻訳プロバイダーが設定されていること |
| 有効ロケールの設定 | `framework.enabled_locales` または各プロバイダーのlocales設定があること |
| 翻訳ファイル出力先 | transPathsが設定されていること |
| プロバイダーへの接続 | 外部翻訳プロバイダーへのネットワーク接続が可能であること |

### 実行可否判定

- 指定されたプロバイダーが存在しない場合はエラー
- --intl-icuオプションは--forceなしでは無効（注意メッセージのみ）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| provider | string | Yes/No | プロバイダーが1つの場合は自動設定 | プル元の翻訳プロバイダー名 |
| --force | bool | No | false | 既存ローカル翻訳をプロバイダーの内容で上書きする（同期されていないメッセージは削除） |
| --intl-icu | bool | No | false | --force使用時にintl-icuドメインファイルとして書き出す |
| --domains | array (string) | No | プロバイダーの全ドメイン | プル対象のドメインを指定 |
| --locales | array (string) | No | enabledLocales | プル対象のロケールを指定 |
| --format | string | No | xlf12 | 出力ファイルフォーマット |
| --as-tree | int | No | null | YAMLツリー構造のインライン切替レベル |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 翻訳プロバイダー | 外部API | プロバイダーの翻訳データ |
| ローカル翻訳ファイル | XLIFF/YAML/PHP等 | transPaths配下の翻訳ファイル（差分計算時に読み込み） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ローカル翻訳ファイル | --formatで指定された形式 | プロバイダーから取得した翻訳データ |
| コンソール（stdout） | テキスト | 処理結果メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {domain}.{locale}.{format}（例: messages.en.xlf） |
| 出力先 | transPathsの最後のパス |
| 文字コード | フォーマット依存 |
| 区切り文字 | フォーマット依存 |

## 処理フロー

### 処理シーケンス

```
1. プロバイダーの取得
   └─ TranslationProviderCollectionからプロバイダーを取得
2. オプションの処理
   ├─ ロケール: --localesオプションまたはenabledLocalesを使用
   ├─ ドメイン: --domainsオプションまたはプロバイダーの全ドメイン
   ├─ フォーマット: xlf12/xlf20をxlfに正規化、xliffバージョンを設定
   └─ --intl-icuと--forceの組み合わせ検証
3. プロバイダーからの翻訳取得
   └─ provider.read(domains, locales)で翻訳データを取得
4. 書き込み処理
   ├─ forceモード: 空のMessageCatalogueとプロバイダー翻訳でTargetOperationを構成し書き込み
   └─ デフォルト: ローカル翻訳を読み込み、プロバイダーの新規翻訳を追加して書き込み
5. 結果出力
   └─ 成功メッセージをコンソールに出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[プロバイダー取得]
    B --> C[ロケール・ドメイン・フォーマット決定]
    C --> D[プロバイダーから翻訳取得]
    D --> E{forceモード?}
    E -->|Yes| F[TargetOperationで書き込み]
    F --> G{intl-icu?}
    G -->|Yes| H[intl-icuドメインに移動]
    G -->|No| I[翻訳ファイル書き込み]
    H --> I
    E -->|No| J[ローカル翻訳読み込み]
    J --> K[プロバイダー差分をローカルに追加]
    K --> L[翻訳ファイル書き込み]
    I --> M[成功メッセージ出力]
    L --> M
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。ローカルファイルと外部翻訳プロバイダーへのAPI通信のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 例外 | プロバイダーが見つからない | プロバイダー設定を確認 |
| - | ネットワークエラー | プロバイダーへの接続失敗 | ネットワーク接続・認証情報を確認 |
| - | ファイル書き込みエラー | 出力先パスに書き込み権限なし | ファイルパーミッションを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（単発実行） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

プロバイダーへの通信エラーが発生した場合は、ネットワーク接続と認証情報を確認の上、再実行する。書き込み途中でエラーが発生した場合、一部のロケール・ドメインのファイルのみが更新された状態になる可能性がある。バージョン管理システムで差分を確認し、必要に応じてロールバックする。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | カタログ単位（ロケールごと） |
| コミットタイミング | 各カタログの書き込み完了時 |
| ロールバック条件 | なし（ファイル書き込みの都度確定） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 翻訳メッセージ数に依存（数十〜数万件） |
| 目標処理時間 | プロバイダーのAPI応答時間に依存 |
| メモリ使用量上限 | 全翻訳データをメモリに読み込むため、大量の翻訳がある場合は注意 |

## 排他制御

コマンドレベルでの排他制御は行われていない。同一翻訳ファイルに対する同時実行は予期しない結果を招く可能性があるため避けることが推奨される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 注意メッセージ | --intl-icuが--forceなしで指定された時 | "--intl-icu option only has an effect when used with --force..." |
| 成功メッセージ | プル完了時（force） | "Local translations has been updated from {provider}..." |
| 成功メッセージ | プル完了時（デフォルト） | "New translations from {provider} has been written locally..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

CI/CDパイプラインで実行する場合は、コマンドのリターンコードを監視することが推奨される。

## 備考

- プロバイダーが1つだけ設定されている場合、provider引数は省略可能
- --formatオプションで対応するフォーマット: php, xlf, xlf12, xlf20, po, mo, yml, yaml, ts, csv, json, ini, res
- xlf12はXLIFF 1.2、xlf20はXLIFF 2.0に対応
- --as-treeオプションはYAMLフォーマットと組み合わせて使用し、指定レベルからインラインYAMLに切り替える
- TranslationTraitのreadLocalTranslationsメソッドを使用してローカル翻訳を読み込む
- forceモードではTargetOperationクラスを使用して、プロバイダー翻訳を基準にローカルファイルを上書きする
- コンソール補完に対応（provider引数、--domainsオプション、--localesオプション、--formatオプション）
- リターンコードは常に0（成功）を返す
