# バッチ設計書 45-lint:translations

## 概要

本ドキュメントは、Symfony Translationコンポーネントの `lint:translations` コマンドのバッチ設計書である。翻訳ファイルの構文を検証し、翻訳メッセージのエラーを検出・出力するコンソールコマンドについて、処理フロー、入出力仕様、エラー処理等を定義する。

### 本バッチの処理概要

`lint:translations` コマンドは、アプリケーションに読み込まれた全翻訳メッセージに対してtrans()メソッドを実行し、ICUメッセージフォーマット等の構文エラーを検出するリントコマンドである。

**業務上の目的・背景**：多言語対応アプリケーションでは、翻訳ファイルに含まれるメッセージの構文が正しいことが重要である。特にICUメッセージフォーマットを使用する場合、プレースホルダーや複数形の構文ミスが実行時エラーを引き起こす。本コマンドは、これらの構文エラーをデプロイ前に検出し、翻訳品質を担保するために使用される。CI/CDパイプラインに組み込むことで、不正な翻訳メッセージのデプロイを防止できる。

**バッチの実行タイミング**：随時（手動実行）。翻訳ファイルの更新後やデプロイ前の検証として実行する。CI/CDパイプラインでの自動実行も推奨される。

**主要な処理内容**：
1. 指定ロケールの翻訳カタログの取得
2. 各ドメインの全翻訳メッセージに対するtrans()実行による構文検証
3. エラーの収集とロケール・ドメイン別の集計
4. 検証結果のテーブル形式出力
5. エラー詳細の出力

**前後の処理との関連**：`translation:extract` で翻訳キーを抽出した後、または `translation:pull` でプロバイダーから翻訳を取得した後に、翻訳内容の妥当性を検証する目的で使用される。`lint:xliff` コマンドがXLIFFファイルの構造的リントを行うのに対し、本コマンドは翻訳メッセージの内容レベルのリントを行う。

**影響範囲**：読み取り専用コマンドであり、翻訳ファイルやシステム状態に影響を与えない。コンソール出力のみ。

## バッチ種別

リント / 品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Translationコンポーネント | Symfony Translationコンポーネントがインストール・設定されていること |
| 翻訳ファイルの存在 | 少なくとも1つの翻訳ファイルが読み込み可能であること |
| ロケールの設定 | enabledLocalesが設定されていること |

### 実行可否判定

- 翻訳ファイルが見つからない場合はエラーメッセージを表示するが、SUCCESS（正常終了）を返す
- ロケールが指定されていない場合はenabledLocalesを使用

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --locale | array (string) | No | enabledLocales | 検証対象のロケールを指定 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 翻訳カタログ | TranslatorBagInterface | TranslatorのgetCatalogue()を通じて取得される翻訳メッセージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール（stdout） | テーブル形式テキスト | ロケール別の検証結果サマリー（Locale, Domains, Valid?） |
| コンソール（stdout） | セクション形式テキスト | エラー詳細（ロケール・ドメイン・翻訳キーごと） |

### 出力ファイル仕様

ファイル出力なし。コンソール出力のみ。

## 処理フロー

### 処理シーケンス

```
1. ロケールの決定
   └─ --localeオプションまたはenabledLocalesを使用
2. ロケールごとの検証ループ
   ├─ 翻訳カタログの取得（translator.getCatalogue(locale)）
   ├─ ドメインの取得
   └─ 各ドメインの全メッセージに対してtrans()を実行
3. エラーの収集
   └─ ExceptionInterface発生時にエラー情報を記録（locale, domain, id, exception）
4. 結果テーブルの表示
   └─ ロケール・ドメイン・検証結果（Yes/No）をテーブル形式で出力
5. エラー詳細の表示（エラーがある場合）
   └─ ロケール・ドメイン別のセクションに分けてエラーメッセージを出力
6. 終了コードの決定
   └─ エラーありの場合FAILURE、なしの場合SUCCESS
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ロケール決定]
    B --> C[ロケールごとにループ]
    C --> D[翻訳カタログ取得]
    D --> E[ドメインごとにループ]
    E --> F[全メッセージにtrans実行]
    F --> G{例外発生?}
    G -->|Yes| H[エラー記録]
    G -->|No| I[次のメッセージ]
    H --> I
    I --> J{次メッセージあり?}
    J -->|Yes| F
    J -->|No| K{次ドメインあり?}
    K -->|Yes| E
    K -->|No| L{次ロケールあり?}
    L -->|Yes| C
    L -->|No| M{翻訳ファイルあり?}
    M -->|No| N[エラー: No translation files found]
    M -->|Yes| O[結果テーブル表示]
    O --> P{エラーあり?}
    P -->|Yes| Q[エラー詳細表示]
    Q --> R[FAILURE返却]
    P -->|No| S[成功メッセージ表示]
    N --> T[SUCCESS返却]
    S --> T
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。読み取り専用コマンドである。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FAILURE (1) | 翻訳構文エラー | 翻訳メッセージのtrans()で例外が発生 | エラー出力の翻訳キーと詳細を確認し、翻訳ファイルを修正 |
| SUCCESS (0) | 翻訳ファイルなし | domainsByLocalesが空 | 翻訳ファイルのパスとロケール設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（単発実行） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

翻訳構文エラーが検出された場合は、エラー出力に示された翻訳キーとエラーメッセージを元に翻訳ファイルを修正し、再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 翻訳メッセージ数に依存（数十〜数万件） |
| 目標処理時間 | 翻訳メッセージ数に依存（通常数秒以内） |
| メモリ使用量上限 | 全翻訳カタログをメモリに読み込むため、大量の翻訳がある場合は注意 |

## 排他制御

読み取り専用コマンドであるため、排他制御は不要。同時実行しても問題は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果テーブル | 検証完了時 | ロケール、ドメイン一覧、Valid?（Yes/No） |
| エラー詳細 | エラー検出時 | "Translation key {id} is invalid:" + エラーメッセージ |
| 成功メッセージ | エラーなし時 | "All translations are valid." |
| エラーメッセージ | 翻訳ファイルなし時 | "No translation files were found." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リターンコード | FAILURE(1)の場合 | CI/CDパイプラインの失敗通知 |

## 備考

- ExceptionInterfaceをcatchしているため、Translationコンポーネント固有の例外のみを検出対象とする
- 翻訳ファイルが存在しない場合もSUCCESSを返す点に注意（エラーメッセージは出力される）
- TranslatorInterface & TranslatorBagInterfaceの交差型で型制約されたtranslatorを使用
- コンソール補完に対応（--localeオプション）
- ICUメッセージフォーマットの構文エラー（プレースホルダーミス、複数形記法エラー等）の検出に特に有効
