# バッチ設計書 47-assets:compress

## 概要

本ドキュメントは、Symfony AssetMapperコンポーネントの `assets:compress` コマンドのバッチ設計書である。指定されたファイルをBrotli、Zstandard、gzip形式で事前圧縮し、Webサーバーから配信するためのコンソールコマンドについて、処理フロー、入出力仕様、エラー処理等を定義する。

### 本バッチの処理概要

`assets:compress` コマンドは、指定されたファイルパスを受け取り、CompressorInterfaceの実装を通じてBrotli、Zstandard、gzip形式の圧縮ファイルを生成するデプロイメントコマンドである。

**業務上の目的・背景**：Webパフォーマンスの最適化において、静的アセット（JavaScript、CSS、HTML等）の圧縮は重要な施策である。Webサーバー（Nginx、Apache等）はリクエスト時にリアルタイムで圧縮を行うが、事前圧縮（pre-compression）済みのファイルを配信することで、サーバーのCPU負荷を軽減し、応答速度を向上させることができる。本コマンドは、デプロイ時にアセットファイルを事前圧縮して、Webサーバーが直接配信できる形式のファイルを生成するために使用される。

**バッチの実行タイミング**：デプロイ時。`asset-map:compile` でアセットをコンパイルした後に実行される。

**主要な処理内容**：
1. 入力パスの取得
2. 各パスに対する圧縮処理（CompressorInterface経由）
3. 圧縮済みファイルの生成（元ファイルと同じディレクトリに拡張子を追加）

**前後の処理との関連**：`asset-map:compile` でコンパイル済みアセットを出力した後に実行される。圧縮ファイルはWebサーバーの設定（例: Nginx の `gzip_static on;`）と連携して使用される。

**影響範囲**：指定されたファイルと同じディレクトリに圧縮ファイルが生成される。元のファイルは保持される。

## バッチ種別

アセット圧縮 / デプロイメント

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | デプロイ時 |
| 実行時刻 | デプロイプロセスに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | デプロイスクリプト / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CompressorInterfaceの実装 | 圧縮処理を行うCompressorInterfaceの実装がDIコンテナに登録されていること |
| 圧縮対象ファイル | paths引数で指定されたファイルが存在すること |
| 書き込み権限 | 圧縮ファイルの出力先ディレクトリに書き込み権限があること |

### 実行可否判定

- paths引数は必須であり、未指定の場合はSymfonyのコマンドバリデーションでエラーとなる

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| paths | array (string) | Yes | なし | 圧縮対象のファイルパス（複数指定可） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ファイルシステム | 各種ファイル | paths引数で指定されたファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ファイルシステム | 圧縮ファイル | 元ファイルと同じディレクトリに圧縮形式の拡張子を付加したファイル |
| コンソール（stdout） | テキスト | 圧縮完了メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {元ファイル名}.{圧縮拡張子}（例: app.js.br, app.js.zst, app.js.gz） |
| 出力先 | 元ファイルと同じディレクトリ |
| 圧縮形式 | Brotli (.br), Zstandard (.zst), gzip (.gz)（CompressorInterface実装依存） |

## 処理フロー

### 処理シーケンス

```
1. paths引数の取得
   └─ コマンドライン引数から圧縮対象のファイルパスを取得
2. 各パスの圧縮処理
   └─ CompressorInterface.compress(path)を各パスに対して実行
3. 結果出力
   └─ 成功メッセージをコンソールに出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[paths引数取得]
    B --> C[パスごとにループ]
    C --> D[compressor.compress実行]
    D --> E{次パスあり?}
    E -->|Yes| C
    E -->|No| F[成功メッセージ出力]
    F --> G[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。ファイルシステムへの書き込みのみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | paths引数が未指定 | 圧縮対象のファイルパスを指定 |
| - | ファイルエラー | 対象ファイルが存在しない | ファイルパスを確認 |
| - | 圧縮エラー | 圧縮ライブラリが未インストール | brotli/zstd/gzipのPHP拡張をインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（単発実行） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

圧縮処理中にエラーが発生した場合は、エラー内容を確認し、圧縮ライブラリのインストール状況やファイルパーミッションを確認の上、再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル単位で処理） |
| コミットタイミング | 各ファイルの圧縮完了時 |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 圧縮対象ファイル数に依存 |
| 目標処理時間 | ファイル数とサイズに依存 |
| メモリ使用量上限 | ファイルサイズに依存（大きなファイルの圧縮時は注意） |

## 排他制御

コマンドレベルでの排他制御は行われていない。同一ファイルに対する同時実行は避けることが推奨される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 成功メッセージ | 全ファイル圧縮完了時 | "File(s) compressed successfully." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| リターンコード | SUCCESS以外の場合 | デプロイパイプラインの失敗通知 |

## 備考

- CompressorInterfaceの実装に依存するため、圧縮形式（Brotli, Zstandard, gzip）はDI設定で制御される
- 元のファイルは保持され、圧縮ファイルが追加で生成される
- Webサーバー側で事前圧縮ファイルの配信を有効にする設定（例: Nginx の `gzip_static on;`、`brotli_static on;`）が必要
- 複数ファイルの場合は"Files"、単数の場合は"File"と表示される
- リターンコードはCommand::SUCCESS（0）を返す
