# バッチ設計書 48-debug:asset-map

## 概要

本ドキュメントは、Symfony AssetMapperコンポーネントの `debug:asset-map` コマンドのバッチ設計書である。AssetMapperに登録された全アセットのマッピング情報（論理パスとファイルシステムパス）をデバッグ用途で一覧表示するコンソールコマンドについて、処理フロー、入出力仕様、エラー処理等を定義する。

### 本バッチの処理概要

`debug:asset-map` コマンドは、AssetMapperに登録された全アセットの論理パス、ファイルシステムパス、および設定されたマッピングディレクトリの情報を表示するデバッグコマンドである。

**業務上の目的・背景**：Symfony AssetMapperでは、アセットファイルが論理パスを通じて参照されるが、マッピング設定が複雑になるとどのファイルがどの論理パスに対応しているか把握が困難になる。本コマンドは、開発者がアセットマッピングの現在の状態を把握し、設定ミスや欠落しているアセットを検出するために使用される。

**バッチの実行タイミング**：随時（手動実行）。開発時やデバッグ時にアセットマッピングの状態を確認する目的で実行する。

**主要な処理内容**：
1. AssetMapperに設定されたディレクトリとネームスペースの一覧表示
2. 全マップ済みアセットの論理パスとファイルシステムパスの一覧表示
3. 名前・拡張子・ベンダーフラグによるフィルタリング
4. パスの短縮表示（--fullオプションで完全パス表示）

**前後の処理との関連**：独立したデバッグコマンドであり、前後の処理依存はない。`asset-map:compile` の前にアセットの状態を確認する用途で使用される。

**影響範囲**：読み取り専用コマンドであり、システム状態に影響を与えない。コンソール出力のみ。

## バッチ種別

デバッグ / 診断ツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| AssetMapperの設定 | Symfony AssetMapperが設定されていること |

### 実行可否判定

特別な実行可否判定ロジックはない。アセットやパスが存在しない場合は警告メッセージを表示する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| name | string | No | null | アセット名またはパスの検索文字列 |
| --ext | string | No | null | 拡張子によるフィルタ（例: css, js, json） |
| --full | bool | No | false | 完全パスを表示する |
| --vendor | bool (negatable) | No | null | ベンダーパッケージのアセットのみ/除外表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| AssetMapperInterface | PHP | マップ済みアセットの情報 |
| AssetMapperRepository | PHP | マッピングディレクトリの情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール（stdout） | テーブル形式テキスト | ディレクトリ一覧（Path, Namespace prefix） |
| コンソール（stdout） | テーブル形式テキスト | アセット一覧（Logical Path, Filesystem Path） |

### 出力ファイル仕様

ファイル出力なし。コンソール出力のみ。

## 処理フロー

### 処理シーケンス

```
1. フィルタ条件の取得
   └─ name引数、--ext/--full/--vendorオプションを取得
2. ディレクトリ一覧の表示（--ext未指定時のみ）
   ├─ AssetMapperRepositoryから全ディレクトリを取得
   ├─ プロジェクトルートからの相対パスに変換
   ├─ name指定時はパスまたはネームスペースでフィルタ
   └─ テーブル形式で表示
3. アセット一覧の表示
   ├─ 全アセットのイテレーション
   ├─ --extによる拡張子フィルタ
   ├─ --vendorによるベンダーフィルタ
   ├─ name指定時は論理パスまたはソースパスでフィルタ
   └─ テーブル形式で表示
4. パス短縮の注意
   └─ パスが短縮された場合、--fullオプションの案内を表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[フィルタ条件取得]
    B --> C{--ext指定?}
    C -->|No| D[ディレクトリ一覧取得]
    D --> E{パスあり?}
    E -->|Yes| F[ディレクトリテーブル表示]
    E -->|No| G[警告: No paths found]
    C -->|Yes| H[アセット検索]
    F --> H
    G --> H
    H --> I{アセットあり?}
    I -->|Yes| J{--full?}
    J -->|Yes| K[完全パスでテーブル表示]
    J -->|No| L[短縮パスでテーブル表示]
    I -->|No| M[警告: No assets found]
    K --> N{パス短縮あり?}
    L --> N
    N -->|Yes| O[--fullオプション案内]
    N -->|No| P[バッチ終了]
    O --> P
    M --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。読み取り専用コマンドである。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 警告 | マッチするパスが見つからない | アセットマッピング設定を確認 |
| - | 警告 | マッチするアセットが見つからない | フィルタ条件を緩和するかアセット設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（単発実行） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

デバッグコマンドであるため、障害時の特別な対応は不要。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | マップ済みアセット数に依存（数十〜数千件） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 全アセットメタデータをメモリに保持 |

## 排他制御

読み取り専用コマンドであるため、排他制御は不要。同時実行しても問題は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| セクション | ディレクトリ一覧表示時 | "Asset Mapper Paths" または "Matched Paths" |
| テーブル | ディレクトリ一覧 | Path, Namespace prefix |
| セクション | アセット一覧表示時 | "Mapped Assets" または "Matched Assets" |
| テーブル | アセット一覧 | Logical Path, Filesystem Path |
| 注意 | パス短縮時 | "To see the full paths, re-run with the --full option." |
| 警告 | パス/アセット未検出時 | "No paths found." / "No assets found." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

デバッグ用途のため、監視・アラートは設定しない。

## 備考

- パスが50文字を超える場合は自動的に短縮され、中央が「...」で省略される
- --vendorオプションはnegatable（--no-vendorで否定形指定可能）
- ディレクトリ一覧はネームスペースの有無でソートされる
- アセット一覧は論理パスでソートされる
- name引数による検索は部分一致（str_contains）で行われる
- リターンコードは常に0（成功）を返す
