# バッチ設計書 49-importmap:require

## 概要

本ドキュメントは、Symfony AssetMapperコンポーネントの `importmap:require` コマンドのバッチ設計書である。JavaScriptパッケージをimportmap.phpに追加し、CDNからのURL解決またはローカルファイルの参照を設定するコンソールコマンドについて、処理フロー、入出力仕様、エラー処理等を定義する。

### 本バッチの処理概要

`importmap:require` コマンドは、JavaScriptパッケージをSymfonyのインポートマップ（importmap.php）に追加するコマンドである。CDNからパッケージのURLを解決するか、ローカルファイルへのパスを指定してインポートマップエントリを登録する。

**業務上の目的・背景**：Symfony AssetMapperでは、npm/yarnの代わりにインポートマップを使用してJavaScriptパッケージを管理する。本コマンドは、npmの `npm install` やyarnの `yarn add` に相当する機能を提供し、フロントエンドの依存パッケージをimportmap.phpに登録するために使用される。バンドラーを使用しないモダンなフロントエンド開発ワークフローの中核をなすコマンドである。

**バッチの実行タイミング**：随時（手動実行）。フロントエンドの依存パッケージを追加する際に開発者が実行する。

**主要な処理内容**：
1. パッケージ名とバージョンの解析
2. CDNからのパッケージURL解決またはローカルパスの設定
3. importmap.phpへのエントリ追加
4. 依存パッケージの自動追加（必要に応じて）
5. バージョン問題のチェックと警告表示

**前後の処理との関連**：`importmap:remove` コマンドと対をなすコマンドである。追加されたパッケージは `importmap:install` でダウンロードされ、`asset-map:compile` でコンパイルされる。`importmap:update` で後からバージョンを更新できる。

**影響範囲**：importmap.phpファイル、およびダウンロードされるパッケージファイルに影響する。

## バッチ種別

依存パッケージ管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| AssetMapperの設定 | Symfony AssetMapperが設定されていること |
| importmap.phpの存在 | プロジェクトルートにimportmap.phpが存在すること |
| ネットワーク接続 | CDNパッケージの場合、外部CDNへのネットワーク接続が可能であること |

### 実行可否判定

- packages引数は必須（未指定の場合はコマンドバリデーションでエラー）
- --pathオプション使用時は1つのパッケージのみ指定可能（複数指定でエラー）
- パッケージ名のフォーマットが不正な場合はエラー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| packages | array (string) | Yes | なし | 追加するパッケージ名（"名前@バージョン"形式、複数可） |
| --entrypoint | bool | No | false | パッケージをエントリポイントとして登録する |
| --path | string | No | null | ローカルファイルパス（プロジェクトルートからの相対パス） |
| --dry-run | bool | No | false | 実際にファイルを変更せずシミュレーション実行する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| CDN | 外部HTTP | JavaScriptパッケージのURL解決 |
| ローカルファイル | ファイルシステム | --pathオプション使用時のローカルJavaScriptファイル |
| importmap.php | PHP | 現在のインポートマップ設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| importmap.php | PHP配列 | 更新されたインポートマップ設定 |
| ダウンロードファイル | JavaScript | CDNからダウンロードされたパッケージファイル |
| コンソール（stdout） | テキスト | 追加結果メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | importmap.php |
| 出力先 | プロジェクトルート |
| 形式 | PHP配列 |

## 処理フロー

### 処理シーケンス

```
1. パッケージ名の解析
   └─ ImportMapManager::parsePackageName()でパッケージ名、バージョン、エイリアスを抽出
2. PackageRequireOptionsの構築
   └─ 各パッケージについてオプション（バージョン、エイリアス、パス、エントリポイント）を設定
3. パッケージの追加実行
   ├─ dry-runモード: importMapManager.requirePackages()（空のImportMapEntriesで実行）
   └─ 通常モード: importMapManager.require()
4. バージョン問題のチェック
   └─ ImportMapVersionCheckerでバージョン互換性を確認・警告表示
5. 結果の出力
   ├─ 1パッケージの場合: "Package {name} added to importmap.php."
   └─ 複数パッケージの場合: "{count} new items ({names}) added to the importmap.php!"
6. verbose出力（-v指定時）
   └─ パッケージ名、バージョン、パスのテーブル表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パッケージ名解析]
    B --> C{パッケージ名有効?}
    C -->|No| D[エラー: 無効なパッケージ名]
    C -->|Yes| E{--path指定?}
    E -->|Yes| F{複数パッケージ?}
    F -->|Yes| G[エラー: pathは単一パッケージのみ]
    F -->|No| H[PackageRequireOptions構築]
    E -->|No| H
    H --> I{dry-run?}
    I -->|Yes| J[シミュレーション実行]
    I -->|No| K[importMapManager.require実行]
    J --> L[バージョンチェック]
    K --> L
    L --> M[結果出力]
    M --> N{verbose?}
    N -->|Yes| O[パッケージ詳細テーブル表示]
    N -->|No| P[成功メッセージ出力]
    O --> P
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。ファイルシステムへの書き込みと外部CDNへのHTTP通信のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FAILURE (1) | 引数エラー | --pathオプションで複数パッケージ指定 | 1パッケージのみ指定 |
| FAILURE (1) | フォーマットエラー | パッケージ名が不正なフォーマット | "PACKAGE@VERSION"形式で指定 |
| - | ネットワークエラー | CDNへの接続失敗 | ネットワーク接続を確認 |
| - | ファイルエラー | --pathで指定したファイルが存在しない | ファイルパスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（単発実行） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

CDN接続エラーの場合は、ネットワーク接続を確認して再実行する。importmap.phpが不正な状態になった場合は、バージョン管理システムで復元する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | importmap.phpの更新全体 |
| コミットタイミング | require()メソッド完了時 |
| ロールバック条件 | なし（ファイル書き込み確定後は復元不可） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 追加パッケージ数に依存（通常1〜数件） |
| 目標処理時間 | CDN応答時間に依存（通常数秒） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

コマンドレベルでの排他制御は行われていない。importmap.phpへの同時書き込みは競合の原因となるため、同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| dry-run通知 | dry-runモード実行時 | "[DRY-RUN] No changes will apply to the importmap configuration." |
| 成功メッセージ | パッケージ追加完了時 | 'Package "{name}" added to importmap.php.' |
| 詳細テーブル | verbose出力時 | Package, Version, Path のテーブル |
| 使用案内 | 1パッケージ追加時 | 'Use the new package normally by importing "{name}".' |
| dry-run完了 | dry-runモード完了時 | "[DRY-RUN] No changes applied to the importmap configuration." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- パッケージ名のフォーマット: `PACKAGE@VERSION`（例: "lodash@^4.15"）、`PACKAGE/PATH`（例: "chart.js/auto"）、`PACKAGE=ALIAS`（例: "vue/dist/vue.esm-bundler.js=vue"）
- 依存パッケージが自動的にインポートマップに追加される場合がある
- --dry-runオプションでファイルシステムへの変更を伴わないシミュレーション実行が可能
- ImportMapVersionCheckerによるバージョン互換性チェックが自動的に実行される
- VersionProblemCommandTraitを使用してバージョン問題を出力に表示
- verbose（-v）モードでパッケージの詳細情報がテーブル形式で表示される
- リターンコードはCommand::SUCCESS（0）またはCommand::FAILURE（1）
