# バッチ設計書 5-cache:pool:list

## 概要

本ドキュメントは、Symfonyフレームワークが提供する `cache:pool:list` コンソールコマンドのバッチ設計書である。アプリケーションに登録されている利用可能なキャッシュプールの名前を一覧表示する処理の仕様を定義する。

### 本バッチの処理概要

`cache:pool:list` コマンドは、DIコンテナに登録されたキャッシュプール名をテーブル形式で一覧表示するシンプルな情報表示コマンドである。

**業務上の目的・背景**：`cache:pool:clear` や `cache:pool:delete` コマンドを実行する前に、利用可能なキャッシュプール名を確認するために使用する。アプリケーションにどのようなキャッシュプールが定義されているかを把握し、運用時のキャッシュ管理を支援する。開発者やオペレーターがプール名を正確に知ることで、誤ったプール名の指定によるエラーを防止できる。

**バッチの実行タイミング**：開発時やデバッグ時、運用メンテナンス時に随時実行される。他のキャッシュ操作コマンドの前に確認用途で使用されることが多い。

**主要な処理内容**：
1. コンストラクタで注入されたプール名配列を取得
2. 各プール名をテーブル行として整形
3. SymfonyStyleのtable()メソッドでテーブル形式に出力

**前後の処理との関連**：`cache:pool:clear`、`cache:pool:delete`、`cache:pool:prune` などのキャッシュ操作コマンドの前に、プール名確認のために実行されることが一般的。

**影響範囲**：読み取り専用のコマンドであり、キャッシュやアプリケーションの状態に一切影響を与えない。

## バッチ種別

情報表示 / ユーティリティコマンド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| アプリケーションが起動可能 | DIコンテナが正常にビルドされている必要がある |

### 実行可否判定

特別な実行可否判定は行わない。コンストラクタで注入されたプール名配列が空の場合でも、空のテーブルが表示される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| （なし） | - | - | - | 入力パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| poolNames | string[] | コンストラクタで注入されるプール名の配列 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stdout | テーブル形式テキスト | "Pool name" ヘッダ付きのテーブルにプール名を列挙 |

### 出力ファイル仕様

該当なし

## 処理フロー

### 処理シーケンス

```
1. プール名配列の取得
   └─ コンストラクタで注入された$poolNames配列を使用
2. テーブルデータの整形
   └─ 各プール名を配列にマッピング
3. テーブル出力
   └─ SymfonyStyle::table()で"Pool name"ヘッダ付きテーブルを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[プール名配列取得]
    B --> C[テーブルデータ整形]
    C --> D[テーブル形式で出力]
    D --> E[バッチ終了 コード0]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 該当なし | - | - | エラーケースは想定されない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

本コマンドは読み取り専用であり、障害が発生する可能性は極めて低い。DIコンテナのビルドエラーが原因の場合は、アプリケーション設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プール数（通常数個〜数十個） |
| 目標処理時間 | ミリ秒単位（即座に完了） |
| メモリ使用量上限 | 最小限 |

## 排他制御

読み取り専用であるため排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 出力データ | コマンド実行時 | プール名のテーブル一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- 非常にシンプルなコマンドであり、コンストラクタで注入されたプール名配列をそのまま出力するのみである。
- テーブルのヘッダは "Pool name" 固定。
- ソースコード: `src/Symfony/Bundle/FrameworkBundle/Command/CachePoolListCommand.php`
