# バッチ設計書 50-importmap:remove

## 概要

本ドキュメントは、Symfony AssetMapperコンポーネントの `importmap:remove` コマンドのバッチ設計書である。importmap.phpからJavaScriptパッケージのエントリを削除し、ダウンロード済みファイルもクリーンアップするコンソールコマンドについて、処理フロー、入出力仕様、エラー処理等を定義する。

### 本バッチの処理概要

`importmap:remove` コマンドは、importmap.phpから指定されたJavaScriptパッケージのエントリを削除するコマンドである。パッケージがアプリにダウンロードされている場合は、ダウンロードされたファイルも同時に削除される。

**業務上の目的・背景**：フロントエンド開発において、不要になったJavaScriptパッケージの依存関係を整理することは、バンドルサイズの削減やセキュリティリスクの軽減に重要である。本コマンドは、npmの `npm uninstall` やyarnの `yarn remove` に相当する機能を提供し、インポートマップからパッケージエントリを安全に削除するために使用される。

**バッチの実行タイミング**：随時（手動実行）。不要なフロントエンド依存パッケージを削除する際に開発者が実行する。

**主要な処理内容**：
1. 削除対象パッケージ名のリスト取得
2. ImportMapManagerを通じたパッケージエントリの削除
3. ダウンロード済みファイルの削除（存在する場合）
4. 削除結果の出力

**前後の処理との関連**：`importmap:require` コマンドと対をなすコマンドである。パッケージの追加は `importmap:require` で行い、削除は本コマンドで行う。

**影響範囲**：importmap.phpファイルおよびダウンロード済みのパッケージファイルに影響する。削除されたパッケージをインポートしているJavaScriptコードは実行時エラーとなる。

## バッチ種別

依存パッケージ管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| AssetMapperの設定 | Symfony AssetMapperが設定されていること |
| importmap.phpの存在 | プロジェクトルートにimportmap.phpが存在すること |
| パッケージの登録 | 削除対象のパッケージがimportmap.phpに登録されていること |

### 実行可否判定

- packages引数は必須（未指定の場合はコマンドバリデーションでエラー）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| packages | array (string) | Yes | なし | 削除するパッケージ名（複数指定可） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| importmap.php | PHP配列 | 現在のインポートマップ設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| importmap.php | PHP配列 | 更新されたインポートマップ設定（エントリ削除後） |
| コンソール（stdout） | テキスト | 削除結果メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | importmap.php |
| 出力先 | プロジェクトルート |
| 形式 | PHP配列 |

## 処理フロー

### 処理シーケンス

```
1. packages引数の取得
   └─ コマンドライン引数から削除対象のパッケージ名リストを取得
2. パッケージの削除実行
   └─ ImportMapManager.remove(packageList)を実行
3. 結果出力
   ├─ 1パッケージの場合: 'Removed "{name}" from importmap.php.'
   └─ 複数パッケージの場合: 'Removed {count} items from importmap.php.'
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[packages引数取得]
    B --> C[importMapManager.remove実行]
    C --> D{パッケージ数}
    D -->|1件| E[単一削除メッセージ出力]
    D -->|複数件| F[複数削除メッセージ出力]
    E --> G[バッチ終了]
    F --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。ファイルシステムへの書き込みのみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | packages引数が未指定 | 削除対象のパッケージ名を指定 |
| - | 例外 | 指定パッケージがimportmapに存在しない | パッケージ名を確認（importmap:requireで登録済みか確認） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（単発実行） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

削除処理でエラーが発生した場合は、importmap.phpの状態をバージョン管理システムで確認し、必要に応じて復元する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | importmap.phpの更新全体 |
| コミットタイミング | remove()メソッド完了時 |
| ロールバック条件 | なし（ファイル書き込み確定後は復元不可） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 削除パッケージ数に依存（通常1〜数件） |
| 目標処理時間 | 即座（ファイル書き込みのみ） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

コマンドレベルでの排他制御は行われていない。importmap.phpへの同時書き込みは競合の原因となるため、同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 成功メッセージ | 削除完了時（1件） | 'Removed "{name}" from importmap.php.' |
| 成功メッセージ | 削除完了時（複数件） | 'Removed {count} items from importmap.php.' |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- ImportMapManagerのremove()メソッドに処理を委譲しており、コマンド自体のロジックは単純
- パッケージがダウンロードされていた場合、ダウンロードされたファイルも同時に削除される（ImportMapManager内部の処理）
- 削除後にそのパッケージをインポートしているJavaScriptコードがある場合、実行時にエラーが発生するため注意が必要
- リターンコードはCommand::SUCCESS（0）を返す
