# バッチ設計書 51-importmap:install

## 概要

本ドキュメントは、Symfony AssetMapperコンポーネントが提供する `importmap:install` コマンドのバッチ設計書である。importmap.phpに定義されたリモートJavaScriptパッケージをダウンロードし、ローカルのvendorディレクトリに保存する処理の仕様を記述する。

### 本バッチの処理概要

`importmap:install` コマンドは、importmap.phpに登録されたサードパーティのJavaScriptパッケージをリモートリポジトリからダウンロードし、プロジェクトのローカルvendorディレクトリに保存するバッチコマンドである。

**業務上の目的・背景**：Symfony AssetMapperでは、JavaScriptの依存パッケージをnpmを使わずにimportmap形式で管理する。リモートパッケージはCDN経由ではなくローカルにダウンロードして配信することで、オフライン環境での利用やパフォーマンスの向上を実現する。本コマンドは、CI/CDパイプラインでの依存パッケージのインストールや、新しい開発環境のセットアップ時に不可欠である。

**バッチの実行タイミング**：プロジェクトの初期セットアップ時、CI/CDデプロイメントパイプライン内、またはimportmap.phpの変更後に手動で随時実行される。

**主要な処理内容**：
1. importmap.phpからリモートパッケージエントリの一覧を読み込む
2. installed.phpと比較し、未ダウンロードまたはバージョン変更があるパッケージを特定する
3. PackageResolverを通じてリモートからパッケージをHTTPダウンロードする
4. ダウンロードしたパッケージ本体と付随するextraFilesをローカルストレージに保存する
5. installed.phpを更新してダウンロード状態を記録する
6. プログレスバーでダウンロード進捗を表示する

**前後の処理との関連**：`importmap:require` でパッケージを追加した後に実行する場合がある。`importmap:update` でバージョンが更新された場合も、内部的にdownloadPackagesが呼ばれる。`asset-map:compile` による本番ビルド前に実行しておく必要がある。

**影響範囲**：プロジェクトのvendorディレクトリ配下のJavaScriptアセットファイル、およびinstalled.phpファイルが更新される。実行時にHTTPリクエストが発生するため、ネットワーク接続が必要となる。

## バッチ種別

データ連携（リモートパッケージダウンロード）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| importmap.phpの存在 | プロジェクトルートにimportmap.phpが存在し、リモートパッケージが定義されていること |
| ネットワーク接続 | リモートパッケージをダウンロードするためにインターネット接続が必要 |
| ファイル書き込み権限 | vendorディレクトリへの書き込み権限があること |

### 実行可否判定

importmap.phpが存在し、リモートパッケージエントリが含まれていること。全てのパッケージが既にダウンロード済みの場合は、ダウンロードをスキップし「No assets to install.」と出力して正常終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| （なし） | - | - | - | 本コマンドには入力引数・オプションはない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| importmap.php | PHP配列 | インポートマップの設定ファイル。リモートパッケージ定義を含む |
| installed.php | PHP配列 | ダウンロード済みパッケージのバージョン・依存関係・extraFilesの記録 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| vendorディレクトリ | JavaScript/CSSファイル | ダウンロードされたパッケージのアセットファイル |
| installed.php | PHP配列 | ダウンロード済みパッケージの状態管理ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | パッケージ名に基づく（RemotePackageStorageが管理） |
| 出力先 | vendorディレクトリ（RemotePackageStorage.getStorageDir()） |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンド実行開始
   └─ SymfonyStyleの初期化、プログレスバーの準備
2. RemotePackageDownloader.downloadPackages()の呼び出し
   └─ installed.phpの読み込みとimportmap.phpのパースを行う
3. ダウンロード対象パッケージの特定
   └─ バージョン比較およびファイル存在チェックにより、ダウンロードが必要なパッケージを抽出
4. パッケージのHTTPダウンロード
   └─ PackageResolverInterface経由で非同期HTTPダウンロードを実行
   └─ プログレスバーのコールバックで進捗表示を更新
5. ダウンロードファイルの保存
   └─ メインコンテンツとextraFilesをRemotePackageStorageに保存
6. installed.phpの更新
   └─ ダウンロード済みパッケージのバージョン・依存関係・extraFiles情報を記録
7. 結果表示
   └─ ダウンロードしたパッケージ数とvendorディレクトリのパスを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[importmap.php読み込み]
    B --> C[installed.php読み込み]
    C --> D{ダウンロード対象パッケージあり?}
    D -->|なし| E["'No assets to install.' と表示"]
    D -->|あり| F[PackageResolverでHTTPダウンロード]
    F --> G[プログレスバー表示・更新]
    G --> H[ファイルをvendorディレクトリに保存]
    H --> I[installed.phpを更新]
    I --> J[ダウンロード結果を表示]
    E --> K[バッチ終了 SUCCESS]
    J --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースを使用しない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | LogicException | ダウンロードしたパッケージが期待と一致しない | パッケージ設定を確認し、再実行する |
| - | InvalidArgumentException | installed.phpのパッケージにバージョン情報がない | installed.phpを削除して再実行する |
| - | LogicException | installed.phpのパッケージに依存関係情報がない | installed.phpを削除して再実行する |
| - | HTTPエラー | ネットワーク障害またはリモートサーバーエラー | ネットワーク接続を確認し、再実行する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Symfony HttpClientのデフォルト設定に依存 |
| リトライ間隔 | Symfony HttpClientのデフォルト設定に依存 |
| リトライ対象エラー | HTTPリクエスト失敗時 |

### 障害時対応

installed.phpが破損した場合は、vendorディレクトリ内のinstalled.phpを削除し、コマンドを再実行することで全パッケージを再ダウンロードできる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステムベースのため、DBトランザクションはなし |
| コミットタイミング | 全パッケージのダウンロード完了後にinstalled.phpを一括更新 |
| ロールバック条件 | 中途失敗時、installed.phpは更新されないため次回再実行で再ダウンロードされる |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクトの依存パッケージ数に依存（一般的に数十パッケージ） |
| 目標処理時間 | ネットワーク速度に依存 |
| メモリ使用量上限 | 特に制限なし（パッケージファイルサイズに依存） |

## 排他制御

同時実行の排他制御は明示的には実装されていない。同一プロジェクトに対して複数のinstallコマンドを同時実行することは推奨されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | ダウンロード中 | プログレスバーによる進捗率とダウンロードURL |
| 終了ログ | バッチ終了時 | ダウンロードしたパッケージ数とvendorディレクトリのパス |
| スキップログ | ダウンロード不要時 | 「No assets to install.」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | プロジェクトに依存 | CI/CDパイプラインのタイムアウト設定 |
| エラー件数 | 1件 | CI/CDパイプラインの失敗通知 |

## 備考

- 本コマンドはSymfony AssetMapperコンポーネントの一部であり、npmやyarnの代替としてJavaScript依存パッケージを管理する
- HTTPダウンロードはSymfony HttpClientを使用した非同期バッチ処理で行われる
- installed.phpにより差分ダウンロードが実現されており、既にダウンロード済みの同一バージョンはスキップされる
- ソースファイル: `src/Symfony/Component/AssetMapper/Command/ImportMapInstallCommand.php`
