# バッチ設計書 52-importmap:update

## 概要

本ドキュメントは、Symfony AssetMapperコンポーネントが提供する `importmap:update` コマンドのバッチ設計書である。importmap.phpに登録されたJavaScriptパッケージを最新バージョンに更新する処理の仕様を記述する。

### 本バッチの処理概要

`importmap:update` コマンドは、importmap.phpに定義されたサードパーティJavaScriptパッケージのバージョンを最新に更新し、対応するアセットファイルを再ダウンロードするバッチコマンドである。

**業務上の目的・背景**：フロントエンドのJavaScript依存パッケージは、セキュリティ修正やバグ修正のために定期的に更新する必要がある。本コマンドにより、npmを使用せずにSymfony AssetMapper管理下のパッケージを最新バージョンに一括更新できる。依存パッケージのバージョン管理を容易にし、プロジェクトのセキュリティと品質を維持する。

**バッチの実行タイミング**：依存パッケージの更新が必要な場合に手動で随時実行される。定期的なセキュリティメンテナンスの一環として週次・月次で実行されることもある。

**主要な処理内容**：
1. importmap.phpから現在のパッケージエントリを読み込む
2. 指定されたパッケージ（または全パッケージ）のリモートパッケージを特定する
3. PackageResolverを通じて最新バージョンを解決する
4. importmap.phpのエントリを新しいバージョン情報で更新する
5. 更新されたパッケージのアセットファイルを再ダウンロードする
6. ImportMapVersionCheckerによるバージョン互換性の警告を表示する

**前後の処理との関連**：`importmap:outdated` で古いパッケージを確認した後に実行する場合がある。更新後は `importmap:audit` でセキュリティチェックを行うことが推奨される。更新後のアセットは `asset-map:compile` で本番ビルドに反映される。

**影響範囲**：importmap.phpの内容が書き換えられる。vendorディレクトリ配下のJavaScriptアセットファイルが更新される。バージョン変更により、フロントエンドの動作に影響を与える可能性がある。

## バッチ種別

データ連携（パッケージバージョン更新・再ダウンロード）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| importmap.phpの存在 | プロジェクトルートにimportmap.phpが存在し、リモートパッケージが定義されていること |
| ネットワーク接続 | パッケージバージョン解決およびダウンロードのためにインターネット接続が必要 |
| ファイル書き込み権限 | importmap.phpおよびvendorディレクトリへの書き込み権限があること |

### 実行可否判定

importmap.phpが存在し、更新対象のリモートパッケージエントリが含まれていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| packages | array (string) | No | 空配列（全パッケージ対象） | 更新対象のパッケージ名リスト。省略時は全パッケージを更新 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| importmap.php | PHP配列 | インポートマップの設定ファイル。現在のパッケージ定義を含む |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| importmap.php | PHP配列 | 更新されたバージョン情報を含むインポートマップ設定 |
| vendorディレクトリ | JavaScript/CSSファイル | 再ダウンロードされたパッケージのアセットファイル |
| installed.php | PHP配列 | ダウンロード済みパッケージの状態管理ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | importmap.php（更新）、パッケージ名に基づくアセットファイル |
| 出力先 | プロジェクトルートおよびvendorディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンド実行開始
   └─ 入力引数（packages）の取得
2. ImportMapManager.update()の呼び出し
   └─ 内部的にupdateImportMapConfig(true, ...)を実行
3. 現在のエントリを読み込み
   └─ importmap.phpから全エントリを取得
4. 更新対象パッケージの特定
   └─ リモートパッケージかつ指定パッケージ（または全件）をフィルタリング
5. 既存パッケージファイルのクリーンアップ
   └─ 既存のアセットファイルを削除
6. PackageResolverで最新バージョン解決
   └─ 各パッケージの最新バージョンを取得
7. importmap.phpの更新
   └─ 新しいバージョン情報でエントリを書き換え
8. パッケージの再ダウンロード
   └─ RemotePackageDownloaderで新バージョンのアセットを取得
9. バージョン互換性チェック
   └─ ImportMapVersionCheckerで依存関係の警告を表示
10. 結果表示
    └─ 更新したパッケージ名を表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[入力引数 packages 取得]
    B --> C[importmap.php読み込み]
    C --> D{特定パッケージ指定?}
    D -->|はい| E[指定パッケージのみフィルタ]
    D -->|いいえ| F[全リモートパッケージ対象]
    E --> G[既存アセットファイル削除]
    F --> G
    G --> H[PackageResolverで最新バージョン解決]
    H --> I[importmap.php更新]
    I --> J[パッケージ再ダウンロード]
    J --> K[バージョン互換性チェック・警告表示]
    K --> L[結果表示]
    L --> M[バッチ終了 SUCCESS]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースを使用しない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidArgumentException | 指定したパッケージがimportmap.phpに存在しない | パッケージ名を確認して再実行する |
| - | RuntimeException | パッケージバージョン解決に失敗 | ネットワーク接続を確認し、再実行する |
| - | LogicException | ローカルパスのアセットが見つからない | アセットファイルの配置を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 組み込みのリトライ機構はなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

更新が途中で失敗した場合、importmap.phpがバージョン管理されていれば `git checkout importmap.php` で元に戻すことができる。その後、`importmap:install` で既存バージョンのパッケージを再ダウンロードする。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステムベースのため、DBトランザクションはなし |
| コミットタイミング | 全パッケージの解決・ダウンロード完了後にimportmap.phpを一括書き込み |
| ロールバック条件 | 自動ロールバック機構はなし。手動でのGitリバートが必要 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクトの依存パッケージ数に依存 |
| 目標処理時間 | ネットワーク速度に依存 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行の排他制御は明示的には実装されていない。同一プロジェクトに対して複数のupdateコマンドを同時実行すると、importmap.phpの競合が発生する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | バージョンチェック時 | 依存パッケージのバージョン互換性に関する警告（VersionProblemCommandTrait） |
| 終了ログ | バッチ終了時 | 更新されたパッケージ名のリスト、または「Updated all packages in importmap.php.」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | プロジェクトに依存 | CI/CDパイプラインのタイムアウト設定 |
| バージョン互換性警告 | 1件以上 | 標準出力で開発者に通知 |

## 備考

- 本コマンドはSymfony AssetMapperコンポーネントの一部であり、npmやyarnの `update` コマンドに相当する機能を提供する
- VersionProblemCommandTraitにより、パッケージ間の依存関係バージョンの不整合が自動的にチェックされ、警告が表示される
- パッケージ名を指定しない場合は全リモートパッケージが更新対象となる
- ソースファイル: `src/Symfony/Component/AssetMapper/Command/ImportMapUpdateCommand.php`
