# バッチ設計書 53-importmap:outdated

## 概要

本ドキュメントは、Symfony AssetMapperコンポーネントが提供する `importmap:outdated` コマンドのバッチ設計書である。importmap.phpに登録されたJavaScriptパッケージの中で、最新バージョンが利用可能なものを一覧表示する処理の仕様を記述する。

### 本バッチの処理概要

`importmap:outdated` コマンドは、importmap.phpに定義されたサードパーティJavaScriptパッケージについて、npm registryに問い合わせて最新バージョンを確認し、更新可能なパッケージを一覧表示するバッチコマンドである。

**業務上の目的・背景**：ソフトウェアの依存パッケージを最新に保つことは、セキュリティ対策と機能改善の両面で重要である。本コマンドにより、開発者はimportmapで管理しているJavaScriptパッケージの中で古くなったものを素早く把握できる。semver互換（マイナー/パッチ）の更新とメジャーアップデート（破壊的変更あり）を色分けして表示することで、更新の優先度判断を支援する。

**バッチの実行タイミング**：定期的なセキュリティチェックの一環として、または `importmap:update` 実行前の確認として手動で随時実行される。

**主要な処理内容**：
1. importmap.phpからリモートパッケージの一覧を読み込む
2. npm registryにHTTPリクエストを送り、各パッケージの最新バージョンを取得する
3. 現在のバージョンと最新バージョンを比較し、更新タイプ（メジャー/マイナー/パッチ）を判定する
4. 更新可能なパッケージをテーブル形式またはJSON形式で出力する
5. semver互換更新は赤色、メジャー更新は黄色で色分け表示する

**前後の処理との関連**：`importmap:require` でパッケージを追加した後に実行し、バージョンの状態を確認する。本コマンドの結果に基づいて `importmap:update` でパッケージを更新する。

**影響範囲**：読み取り専用のコマンドであり、ファイルシステムやデータベースへの変更は一切行わない。npm registryへのHTTPリクエストが発生する。

## バッチ種別

レポート生成（パッケージバージョン状態確認）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| importmap.phpの存在 | プロジェクトルートにimportmap.phpが存在し、リモートパッケージが定義されていること |
| ネットワーク接続 | npm registryへの問い合わせのためにインターネット接続が必要 |

### 実行可否判定

importmap.phpが存在し、リモートパッケージエントリが含まれていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| packages | array (string) | No | 空配列（全パッケージ対象） | チェック対象のパッケージ名リスト |
| --format | string | No | txt | 出力フォーマット。「txt」または「json」 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| importmap.php | PHP配列 | インポートマップの設定ファイル |
| npm registry | HTTP/JSON | パッケージの最新バージョン情報（https://registry.npmjs.org/{package}） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力（txt形式） | テーブル | Package / Current / Latest の3カラムテーブル |
| 標準出力（json形式） | JSON | パッケージ名・現在バージョン・最新バージョン・ステータスの配列 |

### 出力ファイル仕様

ファイル出力はなし。標準出力のみ。

## 処理フロー

### 処理シーケンス

```
1. コマンド実行開始
   └─ 入力引数（packages）とオプション（format）の取得
2. ImportMapUpdateChecker.getAvailableUpdates()の呼び出し
   └─ importmap.phpからリモートパッケージを読み込み
3. npm registryへのHTTPリクエスト
   └─ 各パッケージについてhttps://registry.npmjs.org/{package}にGETリクエスト
   └─ Acceptヘッダ: application/vnd.npm.install-v1+json
4. バージョン比較
   └─ 現在バージョンとdist-tags.latestを比較し、更新タイプを判定
5. 更新可能パッケージのフィルタリング
   └─ hasUpdate()がtrueのパッケージのみを抽出
6. 出力
   └─ txt形式: 色分けテーブル（赤=semver互換、黄=メジャー更新）
   └─ json形式: JSON配列
7. 終了コード
   └─ 更新なし: SUCCESS (0)
   └─ 更新あり: FAILURE (1)
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[入力パラメータ取得]
    B --> C[importmap.phpからリモートパッケージ読み込み]
    C --> D[npm registryにHTTPリクエスト]
    D --> E[バージョン比較・更新タイプ判定]
    E --> F{更新可能パッケージあり?}
    F -->|なし| G[更新なしメッセージ表示]
    F -->|あり| H{出力フォーマット}
    H -->|txt| I[色分けテーブル表示]
    H -->|json| J[JSON出力]
    G --> K[バッチ終了 SUCCESS]
    I --> L[バッチ終了 FAILURE]
    J --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースを使用しない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RuntimeException | npm registryからのHTTPレスポンスが200以外 | ネットワーク接続を確認し、再実行する |
| - | RuntimeException | npm registryのレスポンスからバージョン情報を取得できない | パッケージ名が正しいか確認する |
| - | InvalidArgumentException | サポートされていない出力フォーマットが指定された | txtまたはjsonを指定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 組み込みのリトライ機構はなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

読み取り専用のコマンドであるため、障害が発生してもシステムに影響を与えない。ネットワーク障害の場合は接続を確認して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクトの依存パッケージ数に依存 |
| 目標処理時間 | ネットワーク速度に依存（BatchHttpClientによる並列リクエスト） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用のコマンドであるため、排他制御は不要。同時実行しても問題ない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 終了ログ | 更新なし時 | 「No updates found.」またはJSON空配列 |
| 結果ログ | 更新あり時 | パッケージ名・現在バージョン・最新バージョンのテーブルまたはJSON |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | FAILURE (1) の場合 | 更新可能パッケージの存在を通知（CI/CDパイプライン） |
| 処理時間 | プロジェクトに依存 | タイムアウト設定 |

## 備考

- 本コマンドは読み取り専用であり、importmap.phpやファイルシステムへの変更は行わない
- 終了コードが1（FAILURE）の場合は更新可能なパッケージが存在することを意味する（エラーではない）
- 赤色表示はsemver互換更新（セキュリティ修正等）を示し、早急な更新が推奨される
- 黄色表示はメジャーアップデート（破壊的変更あり）を示す
- npm registryへのHTTPリクエストはBatchHttpClientを使用した並列処理で行われる
- ソースファイル: `src/Symfony/Component/AssetMapper/Command/ImportMapOutdatedCommand.php`
