# バッチ設計書 54-importmap:audit

## 概要

本ドキュメントは、Symfony AssetMapperコンポーネントが提供する `importmap:audit` コマンドのバッチ設計書である。importmap.phpに登録されたJavaScriptパッケージに対してセキュリティ脆弱性アドバイザリをチェックする処理の仕様を記述する。

### 本バッチの処理概要

`importmap:audit` コマンドは、importmap.phpに定義されたリモートJavaScriptパッケージについて、GitHub Advisory Databaseに問い合わせてセキュリティ脆弱性情報を取得し、該当する脆弱性を一覧表示するバッチコマンドである。

**業務上の目的・背景**：サードパーティのJavaScriptパッケージに含まれるセキュリティ脆弱性は、Webアプリケーション全体のセキュリティリスクとなる。本コマンドは、npmの `npm audit` に相当する機能をSymfony AssetMapper環境で提供し、依存パッケージのセキュリティ状態を定期的に確認できるようにする。脆弱性の深刻度（Critical/High/Medium/Low/Unknown）を色分けして表示することで、対応の優先度判断を支援する。

**バッチの実行タイミング**：CI/CDパイプラインでの定期的なセキュリティチェック、デプロイ前の検証、または手動での随時実行。

**主要な処理内容**：
1. importmap.phpからリモートパッケージの一覧とバージョン情報を読み込む
2. GitHub Advisory Database API（https://api.github.com/advisories）にHTTPリクエストを送信する
3. レスポンスからnpmエコシステムの脆弱性情報を抽出する
4. 各パッケージの現在バージョンが脆弱性の影響範囲に含まれるかを判定する
5. 該当する脆弱性をテーブル形式またはJSON形式で出力する

**前後の処理との関連**：`importmap:outdated` と併用して、パッケージの更新状態とセキュリティ状態の両方を確認する。脆弱性が見つかった場合は `importmap:update` でパッケージを更新する。

**影響範囲**：読み取り専用のコマンドであり、ファイルシステムやデータベースへの変更は一切行わない。GitHub APIへのHTTPリクエストが発生する。

## バッチ種別

レポート生成（セキュリティ脆弱性監査）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 / CI/CDパイプラインで定期実行 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| importmap.phpの存在 | プロジェクトルートにimportmap.phpが存在し、リモートパッケージが定義されていること |
| ネットワーク接続 | GitHub Advisory Database APIへの問い合わせのためにインターネット接続が必要 |

### 実行可否判定

importmap.phpが存在し、リモートパッケージエントリが含まれていること。リモートパッケージがない場合は空の結果を返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --format | string | No | txt | 出力フォーマット。「txt」または「json」 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| importmap.php | PHP配列 | インポートマップの設定ファイル |
| GitHub Advisory Database | HTTP/JSON | セキュリティアドバイザリ情報（https://api.github.com/advisories） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力（txt形式） | テーブル | Severity / Title / Package / Version / Patched in / More info の6カラムテーブル |
| 標準出力（json形式） | JSON | packages配列とsummary（深刻度別件数）を含むJSONオブジェクト |

### 出力ファイル仕様

ファイル出力はなし。標準出力のみ。

## 処理フロー

### 処理シーケンス

```
1. コマンド実行開始
   └─ formatオプションの取得
2. ImportMapAuditor.audit()の呼び出し
   └─ importmap.phpからリモートパッケージとバージョン情報を収集
3. GitHub Advisory Database APIへのHTTPリクエスト
   └─ affectsクエリパラメータに「パッケージ名@バージョン」の一覧を送信
4. 脆弱性情報のフィルタリング
   └─ npmエコシステムの脆弱性のみを抽出
   └─ バージョン範囲のマッチングを行い、該当する脆弱性を特定
5. 出力（txt形式）
   └─ 脆弱性テーブルの表示（深刻度で色分け: critical/high=赤, medium=黄, low/unknown=デフォルト）
   └─ パッケージ数とスキップ数のサマリー表示
   └─ バージョン取得できないパッケージの警告表示
   └─ 深刻度別の脆弱性件数サマリー表示
6. 出力（json形式）
   └─ packages配列とsummary（深刻度別カウント）のJSON出力
7. 終了コード
   └─ 脆弱性なし: SUCCESS (0)
   └─ 脆弱性あり: FAILURE (1)
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[formatオプション取得]
    B --> C[importmap.phpからリモートパッケージ収集]
    C --> D{リモートパッケージあり?}
    D -->|なし| E[空結果を返す]
    D -->|あり| F[GitHub Advisory Database APIに問い合わせ]
    F --> G[脆弱性情報のフィルタリング・バージョンマッチング]
    G --> H{脆弱性あり?}
    H -->|なし| I["'No vulnerabilities found.' と表示"]
    H -->|あり| J{出力フォーマット}
    J -->|txt| K[色分けテーブル・サマリー表示]
    J -->|json| L[JSON出力]
    E --> M[バッチ終了 SUCCESS]
    I --> M
    K --> N[バッチ終了 FAILURE]
    L --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースを使用しない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RuntimeException | GitHub APIからのHTTPレスポンスが200以外 | ネットワーク接続およびGitHub APIの状態を確認する |
| - | InvalidArgumentException | サポートされていない出力フォーマットが指定された | txtまたはjsonを指定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 組み込みのリトライ機構はなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

読み取り専用のコマンドであるため、障害が発生してもシステムに影響を与えない。GitHub APIのレート制限に達した場合は、一定時間後に再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクトの依存パッケージ数に依存 |
| 目標処理時間 | ネットワーク速度とGitHub API応答速度に依存 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用のコマンドであるため、排他制御は不要。同時実行しても問題ない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 脆弱性なし時 | 「No vulnerabilities found.」 |
| 警告ログ | バージョン取得不可時 | バージョンを取得できなかったパッケージ名の一覧 |
| 結果ログ | 監査完了時 | パッケージ数（監査済み/スキップ）、脆弱性件数（深刻度別） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | FAILURE (1) の場合 | セキュリティ脆弱性の存在を通知（CI/CDパイプライン） |
| Critical/High脆弱性 | 1件以上 | セキュリティチームに通知 |

## 備考

- 本コマンドは読み取り専用であり、importmap.phpやファイルシステムへの変更は行わない
- 終了コードが1（FAILURE）の場合はセキュリティ脆弱性が存在することを意味する（コマンドのエラーではない）
- GitHub Advisory Database APIを使用しており、GitHub APIのレート制限の影響を受ける可能性がある
- バージョン情報がないパッケージは監査がスキップされ、警告として報告される
- 脆弱性のバージョン範囲マッチングはversion_compare関数を使用して行われる
- SEVERITY_COLORSの定義: critical=red, high=red, medium=yellow, low=default, unknown=default
- ソースファイル: `src/Symfony/Component/AssetMapper/Command/ImportMapAuditCommand.php`
