# バッチ設計書 55-debug:dotenv

## 概要

本ドキュメントは、Symfony Dotenvコンポーネントが提供する `debug:dotenv` コマンドのバッチ設計書である。プロジェクト内の全dotenvファイルとそれらに定義された環境変数の値を一覧表示する処理の仕様を記述する。

### 本バッチの処理概要

`debug:dotenv` コマンドは、Symfonプロジェクトで使用される全てのdotenvファイル（.env, .env.local, .env.{env}等）をスキャンし、各ファイルに定義された環境変数の値を優先度順で一覧表示するデバッグ用バッチコマンドである。

**業務上の目的・背景**：Symfonyアプリケーションの環境設定は複数のdotenvファイルにまたがって定義されることが多く、どのファイルのどの値が最終的に適用されているかを把握するのが困難な場合がある。本コマンドは、環境変数の値がどのdotenvファイルから来ているかを可視化し、環境設定のデバッグを容易にする。

**バッチの実行タイミング**：開発中の環境設定デバッグ時に手動で随時実行される。

**主要な処理内容**：
1. プロジェクトのdotenvファイルパスを特定する（SYMFONY_DOTENV_PATH、composer.json、デフォルトの.env）
2. 環境に応じたdotenvファイルの優先度順リストを生成する（.env.local.php > .env.{env}.local > .env.{env} > .env.local > .env）
3. 各ファイルの存在確認を行い、存在状態を一覧表示する
4. 各ファイルから環境変数を読み込み、ファイル別の値をテーブル形式で表示する
5. 最終的に適用される値を緑色でハイライト表示する

**前後の処理との関連**：`dotenv:dump` で.env.local.phpが生成されている場合、他のdotenvファイルがスキップされる旨の警告を表示する。

**影響範囲**：読み取り専用のコマンドであり、ファイルシステムやデータベースへの変更は一切行わない。

## バッチ種別

デバッグ・診断（環境設定確認）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Dotenvコンポーネントの初期化 | $_SERVER['SYMFONY_DOTENV_VARS']が設定されていること |
| dotenvファイルの存在 | 少なくとも1つのdotenvファイルが存在すること |

### 実行可否判定

$_SERVER['SYMFONY_DOTENV_VARS']が設定されていない場合は「Dotenv component is not initialized.」エラーを表示して終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| filter | string | No | null | 環境変数名またはフィルタ文字列。前方一致でフィルタリングする |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .env | テキスト | メインの環境変数定義ファイル |
| .env.local | テキスト | ローカル上書き用の環境変数定義ファイル |
| .env.{env} | テキスト | 環境別の環境変数定義ファイル |
| .env.{env}.local | テキスト | 環境別ローカル上書き用ファイル |
| .env.local.php | PHP配列 | コンパイル済み環境変数ファイル |
| composer.json | JSON | runtime.dotenv_path設定の参照 |
| $_SERVER | グローバル変数 | 現在の環境変数の実行時値 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テーブル | 環境変数名・現在値・各dotenvファイルでの値のテーブル |

### 出力ファイル仕様

ファイル出力はなし。標準出力のみ。

## 処理フロー

### 処理シーケンス

```
1. コマンド実行開始
   └─ SymfonyStyleの初期化、タイトル「Dotenv Variables & Files」の表示
2. Dotenvコンポーネント初期化チェック
   └─ $_SERVER['SYMFONY_DOTENV_VARS']の存在確認
3. dotenvファイルパスの特定
   └─ SYMFONY_DOTENV_PATH > composer.json(extra.runtime.dotenv_path) > デフォルト(.env)
4. dotenvファイルリストの生成
   └─ 優先度順: .env.local.php > .env.{env}.local > .env.{env} > .env.local(test以外) > .env
5. 警告表示
   └─ .env.local.phpが存在する場合、他ファイルがスキップされる警告
   └─ .envと.env.distが両方存在する場合、.env.distがスキップされる警告
6. ファイル一覧の表示
   └─ 各ファイルの存在状態を色分け表示（緑=存在、赤=不在）
7. 環境変数の読み込み・表示
   └─ 全dotenvファイルから環境変数を読み込み
   └─ フィルタ適用（指定時）
   └─ テーブル形式で表示（最終適用値を緑色、未定義をn/a黄色で表示）
8. 注意事項表示
   └─ 「values might be different between web and CLI」の注記
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{SYMFONY_DOTENV_VARS存在?}
    B -->|なし| C[エラー表示して終了]
    B -->|あり| D[dotenvファイルパス特定]
    D --> E[dotenvファイルリスト生成]
    E --> F[警告表示 .env.local.php / .env.dist]
    F --> G[ファイル一覧表示]
    G --> H[環境変数読み込み]
    H --> I{フィルタ指定あり?}
    I -->|あり| J[前方一致フィルタ適用]
    I -->|なし| K[全変数対象]
    J --> L[テーブル表示]
    K --> L
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースを使用しない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | エラー | SYMFONY_DOTENV_VARSが未設定 | Dotenvコンポーネントを正しく初期化する |
| - | 警告 | .env.local.phpが存在する | 意図した動作か確認する |
| - | 警告 | フィルタに一致する変数がない | フィルタ文字列を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

読み取り専用のコマンドであるため、障害が発生してもシステムに影響を与えない。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | dotenvファイル数（通常5ファイル以内）× 環境変数数 |
| 目標処理時間 | 即時（ファイル読み込みのみ） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用のコマンドであるため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| タイトル | コマンド開始時 | 「Dotenv Variables & Files」 |
| ファイルリスト | スキャン後 | 各dotenvファイルの存在状態 |
| 変数テーブル | 読み込み後 | 環境変数名・値・ファイル別値 |
| 注意事項 | テーブル後 | 「values might be different between web and CLI」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- test環境では.env.localファイルは読み込まれない（Symfonyの標準仕様）
- .env.local.phpが存在する場合、他の全てのdotenvファイルはスキップされる
- composer.jsonのextra.runtime.dotenv_pathで.envファイルのパスをカスタマイズ可能
- 変数値は30文字に切り詰めて表示される（DescriptorHelper.truncate）
- ソースファイル: `src/Symfony/Component/Dotenv/Command/DebugCommand.php`
