# バッチ設計書 56-dotenv:dump

## 概要

本ドキュメントは、Symfony Dotenvコンポーネントが提供する `dotenv:dump` コマンドのバッチ設計書である。.envファイルをPHP最適化ファイル（.env.local.php）にコンパイルする処理の仕様を記述する。

### 本バッチの処理概要

`dotenv:dump` コマンドは、Symfonyプロジェクトの.envファイル群を読み込み、指定された環境の全環境変数を単一のPHPファイル（.env.local.php）にコンパイルするバッチコマンドである。

**業務上の目的・背景**：本番環境では、.envファイルを毎リクエスト解析するのはパフォーマンスのオーバーヘッドとなる。本コマンドにより、環境変数をPHPの配列形式にコンパイルして.env.local.phpに出力することで、ファイル解析を省略し、アプリケーション起動速度を向上させる。CI/CDデプロイメント時の本番環境最適化ステップとして使用される。

**バッチの実行タイミング**：本番環境へのデプロイ時にCI/CDパイプラインで実行される。また、環境変数の変更後に手動で実行することもある。

**主要な処理内容**：
1. プロジェクトディレクトリとdotenvパスを特定する
2. 指定された環境名（prod, devなど）を取得する
3. Dotenvクラスを使用して、環境に応じた全.envファイルを読み込む
4. 読み込んだ環境変数をvar_exportでPHP配列形式に変換する
5. .env.local.phpファイルとして出力する（LOCK_EXオプション付き）

**前後の処理との関連**：`cache:clear` や `cache:warmup` の前に実行することで、キャッシュウォームアップ時に最適化された環境変数を利用できる。`debug:dotenv` で.env.local.phpが存在する場合、他のdotenvファイルがスキップされる。

**影響範囲**：プロジェクトルート直下の.env.local.phpファイルが作成または上書きされる。このファイルが存在すると、Symfonアプリケーション起動時に他のdotenvファイルの読み込みがスキップされる。

## バッチ種別

データ変換（環境設定コンパイル）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | デプロイ時 / 随時 |
| 実行時刻 | デプロイパイプラインに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CDパイプライン / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| .envファイルの存在 | プロジェクトルートに.envファイルが存在すること（--emptyオプション使用時は不要） |
| ファイル書き込み権限 | .env.local.phpの出力先に書き込み権限があること |

### 実行可否判定

環境名が引数またはデフォルト値（kernel.environment）として利用可能であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| env | string | defaultEnvがない場合はYes | kernel.environment | ダンプ対象の環境名（例: prod, dev） |
| --empty | boolean | No | false | .envファイルの内容を無視し、APP_ENVのみを出力する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .env | テキスト | メインの環境変数定義ファイル |
| .env.local | テキスト | ローカル上書き用 |
| .env.{env} | テキスト | 環境別の定義ファイル |
| .env.{env}.local | テキスト | 環境別ローカル上書き用 |
| composer.json | JSON | extra.runtime設定（dotenv_path, env_var_name, test_envs） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .env.local.php | PHP配列 | コンパイル済み環境変数ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | .env.local.php（{dotenvPath}.local.php） |
| 出力先 | プロジェクトルートディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし（PHPファイル） |

## 処理フロー

### 処理シーケンス

```
1. コマンド実行開始
   └─ プロジェクトディレクトリの確認
2. 設定の読み込み
   └─ composer.jsonからruntime設定を読み込み（dotenv_path, env_var_name, test_envs）
3. dotenvパスの特定
   └─ projectDir + (config.dotenv_path || '.env')
4. 環境名の取得
   └─ 引数 > defaultEnv
5. 環境変数の読み込み
   └─ --emptyの場合: APP_ENV（またはカスタムenv_var_name）のみ
   └─ 通常: Dotenv.loadEnv()で全.envファイルを環境に応じて読み込み
   └─ SYMFONY_DOTENV_VARSとSYMFONY_DOTENV_PATHを除外
6. PHPファイル生成
   └─ var_exportで配列をPHP文字列に変換
   └─ file_put_contents(LOCK_EX)で.env.local.phpに書き出し
7. 結果表示
   └─ 「Successfully dumped .env files in .env.local.php for the {env} environment.」
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[composer.jsonからruntime設定読み込み]
    B --> C[dotenvパス・環境名の特定]
    C --> D{--emptyオプション?}
    D -->|はい| E[APP_ENVのみ設定]
    D -->|いいえ| F[Dotenv.loadEnv で全.envファイル読み込み]
    E --> G[var_exportでPHP配列化]
    F --> G
    G --> H[file_put_contents で.env.local.php出力]
    H --> I[成功メッセージ表示]
    I --> J[バッチ終了 SUCCESS]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースを使用しない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RuntimeException | .envファイルが存在しない（--emptyなしの場合） | .envファイルを作成する |
| - | ファイル書き込みエラー | .env.local.phpの書き込みに失敗 | 書き込み権限を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

書き込みに失敗した場合は、出力先の権限を確認する。不正な.env.local.phpが生成された場合は、ファイルを削除して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | file_put_contentsのLOCK_EXオプションによるファイルロック |
| コミットタイミング | 一括書き込み |
| ロールバック条件 | 自動ロールバック機構はなし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 環境変数の数に依存（一般的に数十から数百） |
| 目標処理時間 | 即時（ファイル読み書きのみ） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

file_put_contentsのLOCK_EXオプションにより、書き込み中のファイルロックが行われる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 終了ログ | バッチ終了時 | 「Successfully dumped .env files in .env.local.php for the {env} environment.」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ファイル生成確認 | .env.local.phpが存在すること | デプロイパイプラインの検証ステップ |

## 備考

- 本コマンドはAutoconfigure属性により、kernel.project_dirとkernel.environmentが自動的にバインドされる
- composer.jsonのextra.runtime設定で以下のカスタマイズが可能: dotenv_path（.envファイルパス）, env_var_name（環境変数名、デフォルトAPP_ENV）, test_envs（テスト環境リスト）
- loadEnv実行時、$_SERVERと$_ENVのグローバル変数を一時的に退避・復元する安全設計となっている
- --emptyオプションを使用すると、.envファイルの内容に依存せず、指定した環境名のみを含む最小限の.env.local.phpが生成される
- ソースファイル: `src/Symfony/Component/Dotenv/Command/DotenvDumpCommand.php`
