# バッチ設計書 57-error:dump

## 概要

本ドキュメントは、Symfony ErrorHandlerコンポーネントが提供する `error:dump` コマンドのバッチ設計書である。エラーページをプレーンHTMLファイルとしてダンプし、Webサーバーから直接配信できる静的ファイルを生成する処理の仕様を記述する。

### 本バッチの処理概要

`error:dump` コマンドは、Symfonyアプリケーションのエラーページ（HTTPステータスコード400番台・500番台）を静的HTMLファイルとして指定ディレクトリに出力するバッチコマンドである。

**業務上の目的・背景**：Webアプリケーションが障害でダウンした場合、PHPレベルでのエラーページ生成ができなくなる。事前にエラーページを静的HTMLファイルとしてダンプしておくことで、Webサーバー（Apache、Nginx等）が直接これらのHTMLファイルを配信でき、アプリケーション障害時でもユーザーに適切なエラーページを表示できる。

**バッチの実行タイミング**：デプロイ時のビルドステップとして実行される。エラーページのデザイン変更後に手動で実行することもある。

**主要な処理内容**：
1. 出力先ディレクトリパスを引数から取得する
2. 対象のHTTPステータスコードを特定する（引数指定またはデフォルト: 400番台以上の全コード）
3. 既存の出力ディレクトリがある場合、削除するかを確認する（--forceまたはインタラクティブ確認）
4. 各ステータスコードについて、ErrorRendererInterfaceでエラーページをレンダリングする
5. レンダリング結果を{status_code}.htmlとして指定ディレクトリに保存する

**前後の処理との関連**：`cache:warmup` と同様にデプロイ時のビルドステップの一部として実行される。Webサーバーの設定で、対応するステータスコードに対してこれらの静的HTMLファイルを返すように設定する必要がある。

**影響範囲**：指定ディレクトリにHTMLファイルが生成される。--forceオプション使用時は既存ディレクトリが削除される。

## バッチ種別

レポート生成（静的エラーページ生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | デプロイ時 / 随時 |
| 実行時刻 | デプロイパイプラインに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CDパイプライン / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ErrorRendererの設定 | ErrorRendererInterfaceの実装が利用可能であること |
| ファイル書き込み権限 | 出力先ディレクトリへの書き込み権限があること |

### 実行可否判定

出力先パスが指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| path | string | Yes | なし | エラーページの出力先ディレクトリパス |
| status-codes | array (int) | No | 400番台以上の全コード | ダンプ対象のHTTPステータスコード |
| --force (-f) | boolean | No | false | 確認なしで既存ディレクトリを削除する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Response::$statusTexts | PHP配列 | HTTPステータスコードの定義（Symfony HttpFoundation） |
| ErrorRendererInterface | サービス | エラーページのレンダリングロジック |
| EntrypointLookupInterface | サービス（オプション） | Webpack Encoreのエントリポイント管理（アセット重複防止） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {path}/{status_code}.html | HTML | 各ステータスコードに対応するエラーページ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {ステータスコード}.html（例: 404.html, 500.html） |
| 出力先 | 引数で指定されたディレクトリ |
| 文字コード | ErrorRendererの出力に依存 |
| 区切り文字 | 該当なし（HTMLファイル） |

## 処理フロー

### 処理シーケンス

```
1. コマンド実行開始
   └─ path引数、status-codes引数、--forceオプションの取得
2. タイトル表示
   └─ 「Dumping error pages」
3. ステータスコードの特定
   └─ 引数指定時: 指定されたコードを使用
   └─ 引数未指定時: Response::$statusTextsから400番台以上をフィルタ
4. 既存ディレクトリの処理
   └─ --force: 確認なしで削除
   └─ ディレクトリ存在時: インタラクティブに削除確認（デフォルトNo）
5. エラーページのレンダリング
   └─ 各ステータスコードについてループ
   └─ EntrypointLookupのリセット（Webpack Encore使用時）
   └─ HttpExceptionを生成しErrorRendererでレンダリング
   └─ Filesystemで{path}/{status_code}.htmlに出力
6. 結果表示
   └─ 「Error pages have been dumped in "{path}".」
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ取得]
    B --> C{ステータスコード指定?}
    C -->|あり| D[指定コードを使用]
    C -->|なし| E[400番台以上の全コード]
    D --> F{出力ディレクトリ存在?}
    E --> F
    F -->|あり| G{--forceまたは確認でYes?}
    F -->|なし| I[各ステータスコードでループ]
    G -->|はい| H[既存ディレクトリ削除]
    G -->|いいえ| I
    H --> I
    I --> J[EntrypointLookupリセット]
    J --> K[ErrorRendererでレンダリング]
    K --> L[HTMLファイル出力]
    L --> M{全コード処理完了?}
    M -->|いいえ| I
    M -->|はい| N[成功メッセージ表示]
    N --> O[バッチ終了 SUCCESS]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースを使用しない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル書き込みエラー | 出力先ディレクトリへの書き込み権限がない | 権限を確認する |
| - | レンダリングエラー | ErrorRendererが例外を送出 | ErrorRendererの設定を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

出力先ディレクトリの不完全なHTMLファイルが残る可能性がある。--forceオプションを付けて再実行することで、クリーンな状態から再生成できる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステムベースのため、DBトランザクションはなし |
| コミットタイミング | 各ステータスコードごとにファイル出力 |
| ロールバック条件 | 自動ロールバック機構はなし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 対象ステータスコード数（デフォルトで約30コード） |
| 目標処理時間 | 即時（レンダリングとファイル出力のみ） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行の排他制御は明示的には実装されていない。--forceオプション使用時にディレクトリ削除と再生成が行われるため、同時実行は推奨されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| タイトル | コマンド開始時 | 「Dumping error pages」 |
| 終了ログ | バッチ終了時 | 「Error pages have been dumped in "{path}".」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ファイル生成確認 | 各ステータスコードのHTMLファイルが存在すること | デプロイパイプラインの検証ステップ |

## 備考

- Webpack Encoreを使用している場合、EntrypointLookupInterfaceが注入され、各ページのレンダリング前にリセットされることで、アセットの重複includeが防止される
- デフォルトのステータスコードはResponse::$statusTextsから400番台以上がフィルタされる
- 既存ディレクトリの削除確認はデフォルトでNoであり、--forceオプションまたはインタラクティブ確認でYesを選択する必要がある
- ソースファイル: `src/Symfony/Component/ErrorHandler/Command/ErrorDumpCommand.php`
