# バッチ設計書 58-debug:form

## 概要

本ドキュメントは、Symfony Formコンポーネントが提供する `debug:form` コマンドのバッチ設計書である。フォームタイプの情報（オプション、親タイプ、拡張機能等）を表示するデバッグ用コマンドの仕様を記述する。

### 本バッチの処理概要

`debug:form` コマンドは、Symfonyアプリケーションで利用可能なフォームタイプの情報を詳細に表示するデバッグ用バッチコマンドである。引数なしで実行すると全タイプの一覧を表示し、特定のタイプを指定するとそのオプション定義を表示する。

**業務上の目的・背景**：Symfonyのフォームシステムは多数のビルトインタイプ、サービスタイプ、タイプ拡張を持ち、各タイプが継承階層を通じてオプションを提供する。開発者がフォームを構築する際、利用可能なタイプやオプションを確認する必要がある。本コマンドにより、フォームタイプの構成情報を素早く参照でき、開発効率を向上させる。

**バッチの実行タイミング**：フォーム開発・デバッグ時に手動で随時実行される。

**主要な処理内容**：
1. 引数なし: コアタイプ、サービスタイプ、タイプ拡張、ゲッサーの一覧を表示
2. クラス名指定: 指定されたフォームタイプのResolvedFormTypeを取得し、オプション定義を表示
3. クラス名+オプション名指定: 特定のオプションの詳細定義を表示
4. --show-deprecated: 非推奨オプションを持つタイプのみフィルタ表示
5. --format: txt/json形式での出力切り替え

**前後の処理との関連**：本コマンドは完全に独立したデバッグツールであり、他のバッチとの依存関係はない。

**影響範囲**：読み取り専用のコマンドであり、ファイルシステムやデータベースへの変更は一切行わない。

## バッチ種別

デバッグ・診断（フォームタイプ情報表示）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| FormRegistryの存在 | FormRegistryInterfaceの実装がDIコンテナに登録されていること |
| Formコンポーネントの有効化 | Symfony Formコンポーネントがインストール・有効化されていること |

### 実行可否判定

FormRegistryInterfaceが利用可能であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| class | string | No | null | フォームタイプのクラス名（FQCN または短縮名） |
| option | string | No | null | 表示するオプション名（classが指定されている場合のみ有効） |
| --show-deprecated | boolean | No | false | 非推奨オプションを持つタイプ・オプションのみ表示 |
| --format | string | No | txt | 出力フォーマット（txt, json等。DescriptorHelperに依存） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| FormRegistryInterface | サービス | 登録済みフォームタイプの管理 |
| CoreExtension | クラス | コアフォームタイプの定義 |
| DIコンテナ | サービス | サービスタイプ、タイプ拡張、ゲッサーの一覧 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力（一覧表示） | テキスト/JSON | コアタイプ、サービスタイプ、拡張、ゲッサーの一覧 |
| 標準出力（タイプ詳細） | テキスト/JSON | 指定タイプのオプション定義 |
| 標準出力（オプション詳細） | テキスト/JSON | 指定オプションの詳細定義 |

### 出力ファイル仕様

ファイル出力はなし。標準出力のみ。

## 処理フロー

### 処理シーケンス

```
1. コマンド実行開始
   └─ class引数、option引数、オプションの取得
2. 処理分岐
   └─ classなし: 全タイプ一覧モード
   └─ classあり、optionなし: タイプ詳細モード
   └─ classあり、optionあり: オプション詳細モード
3. [全タイプ一覧モード]
   └─ CoreExtensionからコアタイプ取得（リフレクション使用）
   └─ DIコンテナからサービスタイプ取得（コアタイプを除外）
   └─ --show-deprecated: 非推奨オプションを持つタイプのみフィルタ
   └─ タイプ拡張、ゲッサーの一覧取得
   └─ 各カテゴリをソートして表示
4. [タイプ詳細モード]
   └─ クラス名の解決（短縮名の場合はFQCNに変換）
   └─ FormRegistryからResolvedFormType取得
   └─ DescriptorHelperで詳細表示
5. [オプション詳細モード]
   └─ クラス名の解決
   └─ OptionsResolverからオプション定義取得
   └─ 未定義オプションの場合、代替候補を提案（レーベンシュタイン距離）
   └─ DescriptorHelperでオプション詳細表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{class引数あり?}
    B -->|なし| C[全タイプ一覧表示]
    B -->|あり| D[クラス名FQCN解決]
    D --> E{option引数あり?}
    E -->|なし| F[タイプ詳細表示]
    E -->|あり| G{オプション定義存在?}
    G -->|あり| H[オプション詳細表示]
    G -->|なし| I[代替候補提案・例外]
    C --> J[DescriptorHelperで出力]
    F --> J
    H --> J
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースを使用しない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidArgumentException | 指定されたフォームタイプが見つからない | クラス名を確認する。代替候補が提案される場合がある |
| - | InvalidArgumentException | 短縮名が複数のクラスに一致（非インタラクティブ時） | FQCNで指定する |
| - | InvalidArgumentException | 指定されたオプションが定義されていない | オプション名を確認する。代替候補が提案される場合がある |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

読み取り専用のコマンドであるため、障害が発生してもシステムに影響を与えない。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 登録されているフォームタイプ数に依存 |
| 目標処理時間 | 即時 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用のコマンドであるため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | コマンド終了時 | フォームタイプ情報（DescriptorHelperフォーマットに依存） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- 短縮名（例: ChoiceType）からFQCN（例: Symfony\Component\Form\Extension\Core\Type\ChoiceType）への解決は、登録されたネームスペースを順に検索して行われる
- デフォルトのネームスペースは Symfony\Component\Form\Extension\Core\Type
- 短縮名が複数のクラスに一致する場合、インタラクティブモードでは選択UIが表示される
- 代替候補の提案にはレーベンシュタイン距離による類似度計算が使用される（閾値: 名前の長さの1/3以下）
- FileLinkFormatterが設定されている場合、ソースコードへのリンクが表示される
- CoreExtensionのloadTypesメソッドはリフレクションを通じて呼び出される
- ソースファイル: `src/Symfony/Component/Form/Command/DebugCommand.php`
