# バッチ設計書 59-mailer:test

## 概要

本ドキュメントは、Symfony Mailerコンポーネントが提供する `mailer:test` コマンドのバッチ設計書である。テストメールを送信してMailerトランスポートの動作を確認する処理の仕様を記述する。

### 本バッチの処理概要

`mailer:test` コマンドは、Symfonyアプリケーションに設定されたMailerトランスポートを使用して簡易テストメールを送信し、メール配信基盤の動作を検証するバッチコマンドである。

**業務上の目的・背景**：メール送信機能はWebアプリケーションの重要な機能の一つであり、トランスポート設定（SMTP、SES、SendGrid等）が正しく行われているかを事前に確認する必要がある。本コマンドにより、実際にメールを送信してトランスポートの設定が正しいことを素早く検証できる。新しい環境のセットアップ時やトランスポート設定変更後の動作確認に使用される。

**バッチの実行タイミング**：メールトランスポートの設定後に手動で随時実行される。CI/CDパイプラインでの設定検証にも使用可能。

**主要な処理内容**：
1. 宛先アドレスを引数から取得する
2. 送信元アドレス、件名、本文をオプションから取得する（デフォルト値あり）
3. Email Mimeオブジェクトを構築する
4. トランスポート名が指定された場合、X-Transportヘッダを付与する
5. TransportInterfaceのsendメソッドでメールを送信する

**前後の処理との関連**：本コマンドは独立したテストツールであり、他のバッチとの依存関係はない。Messengerバスが設定されている場合でもバスをバイパスして直接送信する点に注意が必要。

**影響範囲**：実際にメールが送信される。テスト用の宛先アドレスを使用すること。

## バッチ種別

通知配信（メール送信テスト）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Mailerコンポーネントの設定 | TransportInterfaceの実装がDIコンテナに登録されていること |
| トランスポートの設定 | MAILER_DSNまたは対応するトランスポート設定が正しく行われていること |

### 実行可否判定

TransportInterfaceが利用可能であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| to | string | Yes | なし | メールの宛先アドレス |
| --from | string | No | from@example.org | メールの送信元アドレス |
| --subject | string | No | Testing transport | メールの件名 |
| --body | string | No | Testing body | メールの本文（テキスト形式） |
| --transport | string | No | null | 使用するトランスポート名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| TransportInterface | サービス | メール送信トランスポート |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| メール送信 | Email | 指定された宛先にテストメールを送信 |

### 出力ファイル仕様

ファイル出力はなし。

## 処理フロー

### 処理シーケンス

```
1. コマンド実行開始
   └─ to引数、各オプションの取得
2. Emailオブジェクトの構築
   └─ to: 引数から取得
   └─ from: --fromオプション（デフォルト: from@example.org）
   └─ subject: --subjectオプション（デフォルト: Testing transport）
   └─ text: --bodyオプション（デフォルト: Testing body）
3. トランスポート指定の処理
   └─ --transportが指定された場合、X-Transportヘッダを追加
4. メール送信
   └─ TransportInterface::send()でメールを送信
5. コマンド終了
   └─ 戻り値0（SUCCESS）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ取得]
    B --> C[Emailオブジェクト構築]
    C --> D{--transport指定?}
    D -->|あり| E[X-Transportヘッダ追加]
    D -->|なし| F[TransportInterface::send]
    E --> F
    F --> G[バッチ終了 SUCCESS]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースを使用しない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | TransportException | トランスポート設定が不正または接続失敗 | MAILER_DSN設定を確認する |
| - | TransportException | SMTP認証失敗 | 認証情報（ユーザー名/パスワード）を確認する |
| - | InvalidArgumentException | 宛先アドレスの形式が不正 | 正しいメールアドレスを指定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | トランスポートの実装に依存 |
| リトライ間隔 | トランスポートの実装に依存 |
| リトライ対象エラー | トランスポートの実装に依存 |

### 障害時対応

メール送信に失敗した場合は、トランスポート設定（MAILER_DSN）を確認する。SMTP接続の場合は、ホスト名、ポート番号、認証情報を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（テストメール1通） |
| 目標処理時間 | トランスポートの応答速度に依存 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

排他制御は不要。複数同時実行しても問題ない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | コマンド自体にはログ出力なし。トランスポートのログ設定に依存する |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外の場合 | 標準エラー出力 |

## 備考

- 本コマンドはMessengerバスをバイパスして直接TransportInterface::send()を呼び出す。非同期メール送信設定がされている場合でも同期的に送信される
- デフォルトの送信元アドレス（from@example.org）は実際の運用では使用すべきではない。テスト目的でのみ使用する
- X-Transportヘッダにより、複数のトランスポートが設定されている場合に特定のトランスポートを指定して送信できる
- テストメールの本文はテキスト形式のみ（HTML形式は非対応）
- ソースファイル: `src/Symfony/Component/Mailer/Command/MailerTestCommand.php`
