# バッチ設計書 6-cache:pool:prune

## 概要

本ドキュメントは、Symfonyフレームワークが提供する `cache:pool:prune` コンソールコマンドのバッチ設計書である。期限切れのキャッシュアイテムを全てのプルーニング可能なキャッシュプールから削除する処理の仕様を定義する。

### 本バッチの処理概要

`cache:pool:prune` コマンドは、`PruneableInterface` を実装するキャッシュプールに対して `prune()` メソッドを呼び出し、有効期限が切れたキャッシュアイテムを削除する。キャッシュストレージのディスク使用量を適切に管理するためのハウスキーピング処理である。

**業務上の目的・背景**：ファイルベースやデータベースベースのキャッシュアダプターでは、有効期限が切れたアイテムが自動的に削除されない場合がある。時間経過とともに不要なキャッシュデータが蓄積し、ディスク容量を圧迫する問題を防止するために、定期的なプルーニング（剪定）処理が必要となる。RedisやMemcachedなどのインメモリキャッシュでは自動的にTTLベースの削除が行われるが、ファイルシステムアダプターでは本コマンドによる明示的なプルーニングが有効である。

**バッチの実行タイミング**：日次または週次のメンテナンスタスクとしてcronで定期実行されることが推奨される。ディスク使用量の警告が発生した場合の緊急対応としても使用される。

**主要な処理内容**：
1. DIコンテナに登録された `PruneableInterface` 実装のキャッシュプールを順次処理
2. 各プールに対して `prune()` メソッドを呼び出し、期限切れアイテムを削除
3. プルーニングに失敗したプールについてはエラーメッセージを出力
4. 全プールの処理が完了した後、結果に応じて成功メッセージまたは終了コード1を返す

**前後の処理との関連**：`cache:pool:clear` がプール内の全アイテムを削除するのに対し、本コマンドは有効期限切れのアイテムのみを対象とする。定期メンテナンスタスクとして独立して実行される。

**影響範囲**：PruneableInterfaceを実装する全キャッシュプール内の有効期限切れアイテムが削除される。有効なキャッシュアイテムは影響を受けない。

## バッチ種別

キャッシュ管理 / メンテナンスコマンド / ハウスキーピング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次（推奨） |
| 実行時刻 | 低負荷時間帯（例: 深夜） |
| 実行曜日 | 毎日（または週次） |
| 実行日 | 該当なし |
| トリガー | cron / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PruneableInterface実装プールの存在 | DIコンテナに1つ以上のPruneableInterface実装プールが登録されている必要がある |

### 実行可否判定

特別な実行可否判定は行わない。プルーニング可能なプールが0件の場合でも正常終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| （なし） | - | - | - | 入力パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| pools | iterable<string, PruneableInterface> | コンストラクタで注入されるプルーニング可能なプールのイテラブル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stdout | テキスト | 各プールのプルーニング進捗メッセージおよび結果メッセージ |

### 出力ファイル仕様

該当なし

## 処理フロー

### 処理シーケンス

```
1. プールイテレーション開始
   └─ コンストラクタで注入されたプルーニング可能プールを順次処理
2. 各プールのプルーニング
   └─ prune()メソッドを呼び出し、期限切れアイテムを削除
3. 結果判定
   └─ prune()がfalseを返した場合はエラーメッセージを出力し、失敗フラグを立てる
4. 結果出力
   └─ 全プール成功時は成功メッセージ、1つ以上失敗時は終了コード1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[exitCode = SUCCESS]
    B --> C{次のプールあり?}
    C -->|Yes| D[プルーニング実行 prune]
    C -->|No| E{exitCode == SUCCESS?}
    D --> F{prune成功?}
    F -->|Yes| C
    F -->|No| G[エラーメッセージ出力]
    G --> H[exitCode = FAILURE]
    H --> C
    E -->|Yes| I[成功メッセージ出力]
    E -->|No| J[終了コード1]
    I --> K[バッチ終了 コード0]
    J --> L[バッチ終了 コード1]
```

## データベース操作仕様

### 操作別データベース影響一覧

キャッシュバックエンドとしてデータベースが使用されている場合、有効期限切れレコードが削除される可能性がある。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | キャッシュバックエンド依存 |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード1 | プルーニング失敗 | `prune()` がfalseを返した場合 | キャッシュバックエンドの状態・権限を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 特定プールのプルーニングに失敗した場合でも、他のプールの処理は継続される。
2. エラーメッセージから失敗したプール名を特定し、該当プールのバックエンド設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各プール単位で独立 |
| コミットタイミング | 各プールのprune()完了時 |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | PruneableInterface実装プール数に依存 |
| 目標処理時間 | プール数とキャッシュサイズに依存 |
| メモリ使用量上限 | プルーニング対象アイテム数に依存 |

## 排他制御

各プールの `prune()` メソッドの排他制御は、キャッシュアダプターの実装に依存する。コマンド自体には排他制御機構はない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各プール処理時 | `Pruning cache pool: {name}` |
| エラーログ | プルーニング失敗時 | `Cache pool "{name}" could not be pruned.` |
| 終了ログ | 全成功時 | `Successfully pruned cache pool(s).` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 運用監視システム |
| 実行遅延 | cronスケジュールからの逸脱 | 運用監視システム |

## 備考

- `PruneableInterface` を実装していないプール（Redis、Memcached等のインメモリアダプター）は本コマンドの対象外である。これらのアダプターは自身のTTLメカニズムで期限切れアイテムを管理する。
- 定期実行を推奨するため、cronジョブとして設定することが一般的。
- ソースコード: `src/Symfony/Bundle/FrameworkBundle/Command/CachePoolPruneCommand.php`
