# バッチ設計書 60-security:hash-password

## 概要

本ドキュメントは、Symfony PasswordHasherコンポーネントが提供する `security:hash-password` コマンドのバッチ設計書である。ユーザーパスワードをセキュリティ設定に基づいてハッシュ化する処理の仕様を記述する。

### 本バッチの処理概要

`security:hash-password` コマンドは、プレーンテキストのパスワードをSymfonyのセキュリティ設定に基づいたハッシュアルゴリズムでハッシュ化し、結果を表示するバッチコマンドである。

**業務上の目的・背景**：セキュリティ上、パスワードは常にハッシュ化して保存する必要がある。開発中にデータベースにテストユーザーを追加する場合や、in_memoryユーザープロバイダーでパスワードを設定する場合に、適切なハッシュ値を生成する必要がある。本コマンドにより、セキュリティ設定に定義されたハッシュアルゴリズム（bcrypt、argon2i等）に基づいてパスワードをハッシュ化し、すぐに利用可能なハッシュ値を得ることができる。

**バッチの実行タイミング**：開発中のテストデータ作成時、データフィクスチャの準備時、またはin_memoryユーザー設定時に手動で随時実行される。

**主要な処理内容**：
1. ハッシュ対象のパスワードを取得する（引数またはインタラクティブ入力）
2. ユーザークラスを特定する（引数、インタラクティブ選択、または設定のデフォルト）
3. PasswordHasherFactoryからユーザークラスに対応するハッシャーを取得する
4. ソルトの生成・処理を行う（self-saltingハッシャーの場合は自動、レガシーの場合は手動またはランダム生成）
5. パスワードをハッシュ化し、結果をテーブル形式で表示する

**前後の処理との関連**：本コマンドは独立したユーティリティツールであり、他のバッチとの依存関係はない。生成されたハッシュ値は、データフィクスチャやマイグレーションスクリプト、セキュリティ設定ファイルで使用される。

**影響範囲**：読み取り専用のコマンドであり、ファイルシステムやデータベースへの変更は一切行わない。ハッシュ値は標準出力に表示されるのみ。

## バッチ種別

ユーティリティ（パスワードハッシュ生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PasswordHasherFactoryの設定 | security.password_hashers設定が行われていること |
| ユーザークラスの登録 | 少なくとも1つのパスワードハッシャーが設定されていること |

### 実行可否判定

PasswordHasherFactoryInterfaceが利用可能であり、少なくとも1つのユーザークラスに対するハッシャーが設定されていること。ユーザークラスが未設定の場合はRuntimeExceptionが発生する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| password | string | No（インタラクティブ時） | なし | ハッシュ対象のプレーンテキストパスワード |
| user-class | string | No | 設定済みの最初のユーザークラス | ハッシャーに関連付けられたユーザーエンティティクラスパス |
| --empty-salt | boolean | No | false | ソルトを生成しない（ハッシャー自身にソルト生成を任せる） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| PasswordHasherFactoryInterface | サービス | ユーザークラスに基づくハッシャーの取得 |
| security.password_hashers設定 | YAML/PHP | ハッシャーの設定定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テーブル | ハッシャークラス名、ハッシュ値、生成ソルト（該当時）のテーブル |

### 出力ファイル仕様

ファイル出力はなし。標準出力のみ。

## 処理フロー

### 処理シーケンス

```
1. コマンド実行開始
   └─ タイトル「Symfony Password Hash Utility」の表示（インタラクティブ時）
2. パスワードの取得
   └─ 引数指定時: 引数から取得
   └─ インタラクティブ時: 非表示入力でパスワードを要求（最大20回リトライ、空白不可）
   └─ 非インタラクティブ+引数なし: エラー
3. ユーザークラスの特定
   └─ 引数指定時: 指定されたクラスを使用
   └─ インタラクティブ+複数クラス: 選択UIで選択
   └─ 非インタラクティブまたは1クラスのみ: 最初のクラスを使用
   └─ クラス未設定: RuntimeException
4. ハッシャーの取得
   └─ PasswordHasherFactory::getPasswordHasher(userClass)
5. ソルトの処理
   └─ self-saltingハッシャー（非Legacy）: emptySalt=true（自動）
   └─ --empty-salt指定: ソルトなし
   └─ インタラクティブ+非empty-salt: ソルト生成の確認ダイアログ
   └─ 非インタラクティブ+非empty-salt: 自動でソルト生成
6. パスワードハッシュ化
   └─ hasher.hash(password, salt)
7. 結果表示
   └─ テーブル: [Hasher used, Password hash, Generated salt(該当時)]
8. 補足情報表示
   └─ ソルトあり: ソルト保存フィールドの長さに関する注記
   └─ self-salting: 「Self-salting hasher used」の注記
9. 成功メッセージ
   └─ 「Password hashing succeeded」
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{password引数あり?}
    B -->|あり| C[引数から取得]
    B -->|なし| D{インタラクティブ?}
    D -->|はい| E[非表示入力でパスワード取得]
    D -->|いいえ| F[エラー終了]
    C --> G[ユーザークラス特定]
    E --> G
    G --> H[PasswordHasherFactory.getPasswordHasher]
    H --> I{self-saltingハッシャー?}
    I -->|はい| J[emptySalt=true]
    I -->|いいえ| K{--empty-salt?}
    K -->|はい| J
    K -->|いいえ| L{インタラクティブ?}
    L -->|はい| M[ソルト生成確認]
    L -->|いいえ| N[自動ソルト生成]
    J --> O[hasher.hash実行]
    M --> O
    N --> O
    O --> P[結果テーブル表示]
    P --> Q[成功メッセージ]
    Q --> R[バッチ終了 SUCCESS]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースを使用しない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | エラー | 非インタラクティブモードでパスワード未指定 | password引数を指定して実行する |
| - | RuntimeException | パスワードハッシャーが未設定 | security.password_hashers設定を追加する |
| - | InvalidArgumentException | パスワードが空白のみ | 有効なパスワードを入力する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | パスワード入力: 最大20回（setMaxAttempts(20)） |
| リトライ間隔 | 即時（インタラクティブ入力のリトライ） |
| リトライ対象エラー | パスワード入力のバリデーションエラー |

### 障害時対応

読み取り専用のコマンドであるため、障害が発生してもシステムに影響を与えない。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（パスワード1つ） |
| 目標処理時間 | ハッシュアルゴリズムに依存（bcrypt: 数百ms程度） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| タイトル | コマンド開始時（インタラクティブ時） | 「Symfony Password Hash Utility」 |
| 結果テーブル | ハッシュ完了時 | Hasher used / Password hash / Generated salt |
| 注記 | ソルト使用時 | ソルト保存フィールド長に関する注意 |
| 注記 | self-salting時 | 「Self-salting hasher used」 |
| 成功メッセージ | コマンド終了時 | 「Password hashing succeeded」 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- ソルト生成にはrandom_bytes(30)とbase64_encodeが使用される
- self-saltingハッシャー（bcrypt、argon2i等の現代的なハッシャー）では、ハッシャー自身がソルトを生成・管理するため、外部からのソルト指定は不要
- LegacyPasswordHasherInterfaceを実装するハッシャーの場合のみ、外部ソルトの指定が可能
- インタラクティブモードではパスワード入力が非表示（setHidden(true)）で行われる
- 複数のユーザークラスが設定されている場合、インタラクティブモードでは選択UIが表示される
- 非インタラクティブモードでは最初に設定されたユーザークラスが自動選択される
- ソースファイル: `src/Symfony/Component/PasswordHasher/Command/UserPasswordHashCommand.php`
