# バッチ設計書 61-debug:scheduler

## 概要

本ドキュメントは、Symfonyフレームワークの `debug:scheduler` コマンドに関するバッチ設計書である。Schedulerコンポーネントに登録されたスケジュールと定期メッセージの一覧表示およびデバッグを目的としたCLIコマンドの設計を記載する。

### 本バッチの処理概要

`debug:scheduler` コマンドは、Symfonyアプリケーションに設定されたスケジュールプロバイダーから全スケジュールおよび定期メッセージ（RecurringMessage）を取得し、一覧表示する。開発者がスケジュール設定の確認やデバッグを行う際に使用される。

**業務上の目的・背景**：Symfonyアプリケーションにおいて、スケジューラコンポーネントを利用した定期タスク（メッセージ）は設定ファイルやPHPコードで定義されるため、現在どのようなスケジュールが登録されているかを一目で確認する手段が必要である。本コマンドはこの運用課題を解決し、定期メッセージのトリガー条件・次回実行日時・プロバイダーを一覧形式で出力することで、設定ミスの早期発見とデバッグを支援する。

**バッチの実行タイミング**：開発・運用時に手動で随時実行する。スケジュール設定の確認やトラブルシューティング時に利用される。

**主要な処理内容**：
1. 引数またはデフォルトで対象スケジュール名を決定する
2. `--date` オプションで指定された日時（デフォルトは現在時刻）を基準日として設定する
3. 各スケジュール名に対応する `ScheduleProviderInterface` からスケジュール定義を取得する
4. スケジュール内の `RecurringMessage` を取得し、トリガー情報・プロバイダー情報・次回実行日時を抽出する
5. `--all` オプションが指定されていない場合、終了済み（次回実行日時がnull）の定期メッセージを除外する
6. `--sort` オプションが指定されている場合、次回実行日時でソートする
7. Trigger / Provider / Next Run の3列テーブル形式で結果を出力する

**前後の処理との関連**：本コマンドは読み取り専用のデバッグコマンドであり、他のバッチ処理の前提条件や後続処理としての依存関係はない。ただし、`messenger:consume` コマンドによるメッセージ消費処理と関連するスケジュール情報を表示する。

**影響範囲**：読み取り専用のため、システムやデータへの影響はない。Schedulerコンポーネントの `ScheduleProviderInterface` の実装に依存する。

## バッチ種別

デバッグ / 情報表示

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Schedulerコンポーネントの有効化 | Symfony Schedulerコンポーネントがインストールされ、サービスコンテナに登録されていること |
| スケジュールプロバイダーの設定 | 1つ以上の `ScheduleProviderInterface` 実装がServiceProviderとして登録されていること |

### 実行可否判定

ServiceProviderInterfaceから取得できるスケジュール名が0件の場合、「No schedules found.」エラーを出力して終了コード2を返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| schedule | string[] | No | 全スケジュール名 | 表示対象のスケジュール名（複数指定可） |
| --date | string | No | "now" | 次回実行日時の計算基準となる日時文字列 |
| --all | bool | No | false | 終了済みの定期メッセージも含めて表示する |
| --sort | bool | No | false | 次回実行日時で昇順ソートする |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ServiceProviderInterface (schedules) | メモリ内オブジェクト | コンテナに登録されたScheduleProviderInterfaceのコレクション |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テーブル形式テキスト | Trigger / Provider / Next Run の3列テーブル |

### 出力ファイル仕様

ファイル出力はない。標準出力（コンソール）にテーブル形式で結果を表示する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力） |
| 出力先 | コンソール |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（テーブル形式） |

## 処理フロー

### 処理シーケンス

```
1. コマンド初期化
   └─ コンストラクタでServiceProviderから利用可能なスケジュール名を取得
2. 引数のパース
   └─ schedule引数、--date/--all/--sortオプションを取得
3. 対象スケジュール名の決定
   └─ 引数指定があればその値、なければ全スケジュール名を使用
4. 基準日時の設定
   └─ --dateオプションの値でDateTimeImmutableを生成（デフォルト: now）
5. スケジュールごとのループ処理
   └─ 各スケジュール名に対してScheduleProviderを取得
6. RecurringMessage一覧の取得
   └─ getSchedule()->getRecurringMessages()で定期メッセージを取得
7. メッセージ情報の抽出
   └─ 各RecurringMessageからTrigger, Provider, 次回実行日時を取得
8. フィルタリング
   └─ --allが未指定の場合、次回実行日時がnullのメッセージを除外
9. ソート（オプション）
   └─ --sortが指定されている場合、次回実行日時で昇順ソート
10. 結果出力
    └─ テーブル形式でTrigger / Provider / Next Runを出力
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B{schedule引数あり?}
    B -->|あり| C[指定スケジュール名を使用]
    B -->|なし| D[全スケジュール名を使用]
    C --> E{スケジュール名が0件?}
    D --> E
    E -->|はい| F[エラー出力 / 終了コード2]
    E -->|いいえ| G[基準日時を設定]
    G --> H[スケジュールごとにループ]
    H --> I[ScheduleProviderを取得]
    I --> J[RecurringMessagesを取得]
    J --> K{メッセージあり?}
    K -->|なし| L[警告出力]
    K -->|あり| M[メッセージ情報を抽出・フィルタリング]
    M --> N{--sort指定?}
    N -->|はい| O[次回実行日時でソート]
    N -->|いいえ| P[テーブル出力]
    O --> P
    L --> Q{次のスケジュールあり?}
    P --> Q
    Q -->|あり| H
    Q -->|なし| R[コマンド終了 / 終了コード0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 2 | スケジュール未検出 | スケジュール名が0件 | スケジュールプロバイダーの設定を確認 |
| - | 警告 | 指定スケジュールにRecurringMessageが0件 | スケジュール定義を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（対話的コマンドのためリトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

読み取り専用のデバッグコマンドであるため、障害時のリカバリ手順は不要。エラーが発生した場合は、スケジュールプロバイダーの設定やサービスコンテナの構成を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | スケジュール数 x 定期メッセージ数（通常数十件程度） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 通常のCLIコマンドの範囲内 |

## 排他制御

読み取り専用コマンドであるため、排他制御は不要。同時実行も問題なく動作する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | デバッグコマンドのため明示的なログ出力なし |
| 進捗ログ | N/A | N/A |
| 終了ログ | N/A | N/A |
| エラーログ | エラー発生時 | SymfonyStyleを通じたエラーメッセージ出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | デバッグコマンドのため監視不要 |

## 備考

- 本コマンドはSymfony Schedulerコンポーネント（`symfony/scheduler`）の一部として提供される。
- `ServiceProviderInterface` を通じてスケジュールプロバイダーにアクセスするため、サービスコンテナの設定が正しく行われている必要がある。
- `--date` オプションにより、将来の特定日時における次回実行予定を確認することが可能。
- 作者: Kevin Bond
