# バッチ設計書 62-security:oidc:generate-token

## 概要

本ドキュメントは、Symfonyフレームワークの `security:oidc:generate-token` コマンドに関するバッチ設計書である。指定ユーザーに対するOIDC（OpenID Connect）トークンの生成を行うCLIコマンドの設計を記載する。

### 本バッチの処理概要

`security:oidc:generate-token` コマンドは、指定されたユーザー識別子に基づいてOIDCトークン（JWT）を生成し、標準出力に出力する。ファイアウォール設定に基づいた `OidcTokenGenerator` を使用し、署名アルゴリズム・発行者・有効期限などを指定してトークンを生成する。

**業務上の目的・背景**：Symfonyアプリケーションにおいて、OIDC認証を実装する際に、テスト用途や開発時のデバッグ目的でOIDCトークンを手動生成する必要がある。本コマンドは、実際のOIDCプロバイダーを経由せずにトークンを生成することで、開発効率の向上やAPIテストの簡素化を実現する。

**バッチの実行タイミング**：開発・テスト時に手動で随時実行する。OIDC認証のテストやデバッグ時に利用される。

**主要な処理内容**：
1. ユーザー識別子（必須引数）を受け取る
2. ファイアウォール名を特定する（指定がなければ自動選択）
3. 対応する `OidcTokenGenerator` を取得する
4. 指定されたオプション（アルゴリズム、発行者、TTL、Not Before）でトークンを生成する
5. 生成されたトークン文字列を標準出力に出力する

**前後の処理との関連**：本コマンドは独立したユーティリティコマンドであり、他のバッチ処理との直接的な依存関係はない。生成されたトークンは、OIDC認証を使用するAPIエンドポイントのテストに利用される。

**影響範囲**：読み取り専用（トークン生成のみ）であり、データベースやファイルシステムへの書き込みは行わない。生成されたトークンの有効性はファイアウォール設定に依存する。

## バッチ種別

ユーティリティ / トークン生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| OIDC設定の有効化 | SecurityBundleでOIDCトークン生成が設定されていること |
| OidcTokenGeneratorの登録 | 少なくとも1つのファイアウォールにOidcTokenGeneratorが登録されていること |
| 署名鍵の設定 | トークン署名に使用する秘密鍵が設定されていること |

### 実行可否判定

`OidcTokenGenerator` が1つも登録されていない場合、「No OIDC token generator configured.」エラーを投げて終了する。複数のファイアウォールが登録されており、`--firewall` オプションが未指定の場合もエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| user-identifier | string | Yes | なし | トークンを生成するユーザーの識別子 |
| --firewall | string | No | なし（自動選択） | 使用するファイアウォール名 |
| --algorithm | string | No | なし（デフォルトアルゴリズム） | トークン署名に使用するアルゴリズム名 |
| --issuer | string | No | なし（デフォルト発行者） | Issuer claim (iss)の値 |
| --ttl | string | No | なし（デフォルトTTL） | Expiration Time claim (exp)の有効期間（秒） |
| --not-before | string | No | なし | Not Before claim (nbf)の日時文字列 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| OidcTokenGenerator (サービスコンテナ) | メモリ内オブジェクト | ファイアウォールごとに登録されたトークン生成器 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | プレーンテキスト | 生成されたOIDCトークン（JWT文字列） |

### 出力ファイル仕様

ファイル出力はない。標準出力にトークン文字列のみを出力する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力） |
| 出力先 | コンソール |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. コマンド実行
   └─ user-identifier引数とオプションを取得
2. ファイアウォールの選択
   └─ --firewallオプション指定時はその値を使用
   └─ 未指定かつ1つだけ登録されている場合は自動選択
   └─ 未指定かつ複数登録されている場合はエラー
3. OidcTokenGeneratorの取得
   └─ 選択されたファイアウォールに対応するジェネレーターを取得
4. トークン生成
   └─ user-identifier, algorithm, issuer, ttl, not-beforeを渡して生成
5. 結果出力
   └─ 生成されたトークン文字列を標準出力に出力
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B{ジェネレーター登録あり?}
    B -->|なし| C[エラー: No OIDC token generator configured]
    B -->|あり| D{--firewall指定あり?}
    D -->|あり| E{指定ファイアウォール存在?}
    E -->|なし| F[エラー: Invalid firewall]
    E -->|あり| G[ジェネレーター取得]
    D -->|なし| H{登録数 = 1?}
    H -->|はい| G
    H -->|いいえ| I[エラー: Please choose a firewall]
    G --> J[トークン生成]
    J --> K[標準出力にトークン出力]
    K --> L[コマンド終了 / SUCCESS]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidArgumentException | OidcTokenGeneratorが0件登録 | OIDC設定を確認し、ファイアウォールにOidcTokenGeneratorを登録する |
| - | InvalidArgumentException | 指定ファイアウォールが未登録 | 有効なファイアウォール名を指定する |
| - | InvalidArgumentException | 複数ファイアウォール登録時にファイアウォール未指定 | --firewallオプションでファイアウォール名を指定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（対話的コマンドのためリトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ユーティリティコマンドであるため、障害時のリカバリ手順は不要。エラーが発生した場合は、セキュリティ設定（ファイアウォール設定、OIDC設定）を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1トークン/実行 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 通常のCLIコマンドの範囲内 |

## 排他制御

トークン生成は状態を変更しないため、排他制御は不要。同時実行も問題なく動作する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | ユーティリティコマンドのため明示的なログ出力なし |
| 進捗ログ | N/A | N/A |
| 終了ログ | N/A | N/A |
| エラーログ | エラー発生時 | InvalidArgumentExceptionのメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | ユーティリティコマンドのため監視不要 |

## 備考

- 本コマンドはSymfony SecurityBundle（`symfony/security-http`）の一部として提供される。
- `addGenerator` メソッドを通じてファイアウォールごとにOidcTokenGeneratorが登録される。
- コンソール補完機能（CompletionInput/CompletionSuggestions）をサポートしており、`--firewall`、`--algorithm`、`--issuer` オプションの値が自動補完される。
- `--not-before` オプションはDateTimeImmutableにパース可能な日時文字列を受け付ける。
- 生成されるトークンのセキュリティは、設定された署名アルゴリズムと秘密鍵の強度に依存する。
