# バッチ設計書 63-debug:serializer

## 概要

本ドキュメントは、Symfonyフレームワークの `debug:serializer` コマンドに関するバッチ設計書である。指定されたクラスのシリアライゼーション情報（グループ、最大深度、シリアライズ名など）をデバッグ表示するCLIコマンドの設計を記載する。

### 本バッチの処理概要

`debug:serializer` コマンドは、指定されたクラスのシリアライザメタデータを `ClassMetadataFactoryInterface` から取得し、各プロパティのシリアライゼーション設定をテーブル形式で表示する。開発者がシリアライゼーション設定のデバッグや確認を行う際に使用される。

**業務上の目的・背景**：SymfonyのSerializerコンポーネントでは、アノテーションやPHPアトリビュート、YAMLなどでシリアライゼーション設定（グループ、最大深度、カスタム名など）を定義する。これらの設定は分散して記述されるため、特定クラスの最終的なシリアライゼーション構成を一覧確認する手段が必要である。本コマンドはこの確認作業を支援し、設定ミスの早期発見に役立てる。

**バッチの実行タイミング**：開発時に手動で随時実行する。シリアライゼーション設定の確認やAPI出力のデバッグ時に利用される。

**主要な処理内容**：
1. 引数としてFQCN（完全修飾クラス名）を受け取る
2. クラスの存在確認を行う
3. `ClassMetadataFactoryInterface` からクラスメタデータを取得する
4. 各アトリビュート（プロパティ）のメタデータを抽出する（groups, maxDepth, serializedName, serializedPath, ignore, normalizationContexts, denormalizationContexts）
5. クラスディスクリミネータマッピングが存在する場合、対応プロパティにdiscriminatorMapを追加する
6. Property / Options の2列テーブル形式で結果を出力する

**前後の処理との関連**：本コマンドは読み取り専用のデバッグコマンドであり、他のバッチ処理の前提条件や後続処理としての依存関係はない。

**影響範囲**：読み取り専用のため、システムやデータへの影響はない。Serializerコンポーネントの `ClassMetadataFactoryInterface` の実装に依存する。

## バッチ種別

デバッグ / 情報表示

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Serializerコンポーネントの有効化 | Symfony Serializerコンポーネントがインストールされていること |
| ClassMetadataFactoryの登録 | `ClassMetadataFactoryInterface` がサービスコンテナに登録されていること |

### 実行可否判定

指定されたクラスが存在しない場合（`class_exists` が false）、エラーメッセージを出力して `FAILURE` を返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| class | string | Yes | なし | シリアライゼーション情報を表示する完全修飾クラス名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ClassMetadataFactoryInterface | メモリ内オブジェクト | クラスのシリアライザメタデータを提供するファクトリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テーブル形式テキスト | Property / Options の2列テーブル |

### 出力ファイル仕様

ファイル出力はない。標準出力（コンソール）にテーブル形式で結果を表示する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力） |
| 出力先 | コンソール |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（テーブル形式） |

## 処理フロー

### 処理シーケンス

```
1. コマンド実行
   └─ class引数を取得
2. クラス存在確認
   └─ class_exists()でクラスの存在を確認
3. メタデータ取得
   └─ ClassMetadataFactoryInterface::getMetadataFor()でクラスメタデータを取得
4. アトリビュートデータ抽出
   └─ 各アトリビュートメタデータからgroups, maxDepth, serializedName等を取得
5. ディスクリミネータマッピング処理
   └─ クラスディスクリミネータマッピングが存在する場合、対応プロパティに追加
6. 結果出力
   └─ Property / Options の2列テーブルを出力（データがない場合はメッセージ表示）
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B{クラス存在?}
    B -->|なし| C[エラー: Class not found / FAILURE]
    B -->|あり| D[ClassMetadataFactory からメタデータ取得]
    D --> E[アトリビュートデータ抽出]
    E --> F{ディスクリミネータマッピングあり?}
    F -->|あり| G[discriminatorMapを追加]
    F -->|なし| H{プロパティデータあり?}
    G --> H
    H -->|なし| I[No Serializer data メッセージ表示]
    H -->|あり| J[Property/Options テーブル出力]
    I --> K[コマンド終了 / SUCCESS]
    J --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FAILURE | クラス未検出 | 指定されたクラスが存在しない | クラス名（FQCN）の正確性を確認、オートローダーの設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（対話的コマンドのためリトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

読み取り専用のデバッグコマンドであるため、障害時のリカバリ手順は不要。エラーが発生した場合は、クラス名の正確性やオートローダーの設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1クラス/実行（プロパティ数はクラスに依存） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 通常のCLIコマンドの範囲内 |

## 排他制御

読み取り専用コマンドであるため、排他制御は不要。同時実行も問題なく動作する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | デバッグコマンドのため明示的なログ出力なし |
| 進捗ログ | N/A | N/A |
| 終了ログ | N/A | N/A |
| エラーログ | エラー発生時 | SymfonyStyleを通じたエラーメッセージ出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | デバッグコマンドのため監視不要 |

## 備考

- 本コマンドはSymfony Serializerコンポーネント（`symfony/serializer`）の一部として提供される。
- 表示されるプロパティオプションは以下の7項目：groups, maxDepth, serializedName, serializedPath, ignore, normalizationContexts, denormalizationContexts。
- クラスディスクリミネータマッピングが設定されている場合、タイププロパティにdiscriminatorMapが追加で表示される。
- 出力にはConsole Helperの `Dumper` クラスが使用され、オプション値が見やすくフォーマットされる。
- 作者: Loic Fremont
