# バッチ設計書 64-uuid:generate

## 概要

本ドキュメントは、Symfonyフレームワークの `uuid:generate` コマンドに関するバッチ設計書である。RFC 4122準拠のUUIDを各種バージョン（時間ベース、名前ベース、ランダムベース）で生成するCLIコマンドの設計を記載する。

### 本バッチの処理概要

`uuid:generate` コマンドは、Symfony Uidコンポーネントの `UuidFactory` を使用して、指定された方式（時間ベース、名前ベース、ランダムベース、またはデフォルト）でUUIDを生成し、指定されたフォーマット（rfc4122, base32, base58）で標準出力に出力する。複数のUUIDを一括生成することも可能。

**業務上の目的・背景**：アプリケーション開発において、一意識別子（UUID）は主キーやトランザクションID、相関IDなどに広く使用される。本コマンドは開発者がCLIから手軽にUUIDを生成する手段を提供し、テストデータの作成やスクリプトへの組み込みを支援する。

**バッチの実行タイミング**：開発・運用時に手動で随時実行する。UUID生成が必要な場面で利用される。

**主要な処理内容**：
1. 生成方式（時間ベース/名前ベース/ランダムベース/デフォルト）を決定する
2. オプションの入力検証を行う（排他チェック、依存チェック）
3. 時間ベースの場合はタイムスタンプとノード（オプション）を設定する
4. 名前ベースの場合は名前と名前空間（オプション）を設定する
5. `UuidFactory` を使用してUUIDを生成する
6. 指定されたフォーマットで出力する（count回数分繰り返し）

**前後の処理との関連**：本コマンドは独立したユーティリティコマンドであり、他のバッチ処理との直接的な依存関係はない。生成されたUUIDはパイプやスクリプトで利用可能。

**影響範囲**：読み取り専用（UUID生成・出力のみ）であり、システムやデータへの影響はない。

## バッチ種別

ユーティリティ / ID生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Uidコンポーネントの有効化 | Symfony Uidコンポーネント（`symfony/uid`）がインストールされていること |

### 実行可否判定

入力オプションの排他チェック（`--time-based`, `--name-based`, `--random-based` のうち最大1つ）および依存チェック（`--node` は `--time-based` との同時指定が必要、`--namespace` は `--name-based` との同時指定が必要）で不正な場合はエラーコード1を返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --time-based | string | No | なし | 時間ベースUUID生成用のタイムスタンプ（パース可能な日時文字列） |
| --node | string | No | なし | 時間ベースUUIDのノード部として使用するUUID |
| --name-based | string | No | なし | 名前ベースUUID生成用の名前文字列 |
| --namespace | string | No | なし | 名前ベースUUIDの名前空間UUID（または定義済みキーワード: dns, url, oid, x500） |
| --random-based | bool | No | false | ランダムベースUUIDを生成する |
| --count (-c) | int | No | 1 | 生成するUUIDの数 |
| --format (-f) | string | No | "rfc4122" | 出力フォーマット（rfc4122, base32, base58） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| UuidFactory | メモリ内オブジェクト | UUID生成ファクトリ（コンストラクタでDI可能） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | プレーンテキスト | 生成されたUUID文字列（1行1UUID） |

### 出力ファイル仕様

ファイル出力はない。標準出力にUUID文字列を出力する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力） |
| 出力先 | コンソール |
| 文字コード | UTF-8 |
| 区切り文字 | 改行（1UUID1行） |

## 処理フロー

### 処理シーケンス

```
1. オプション取得
   └─ time-based, node, name-based, namespace, random-based, count, formatを取得
2. 排他チェック
   └─ time-based, name-based, random-basedのうち2つ以上が指定されていないか確認
3. 依存チェック
   └─ nodeはtime-basedと、namespaceはname-basedと同時指定が必要
4. 生成方式の決定
   └─ time-based → timeBased(), name-based → nameBased(), random-based → randomBased(), デフォルト → create()
5. 入力値の検証
   └─ node: UUID形式チェック、time: 日時パースチェック、namespace: UUID形式 or 定義済みキーワードチェック
6. フォーマットの検証
   └─ rfc4122, base32, base58のいずれかであることを確認
7. UUID生成ループ
   └─ count回数分UUIDを生成し、指定フォーマットで標準出力に出力
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B{排他チェックOK?}
    B -->|NG| C[エラー: 複数方式の同時指定不可]
    B -->|OK| D{依存チェックOK?}
    D -->|NG| E[エラー: オプション依存関係違反]
    D -->|OK| F{生成方式の決定}
    F -->|time-based| G[タイムスタンプ・ノード検証]
    F -->|name-based| H[名前・名前空間検証]
    F -->|random-based| I[randomBased生成器]
    F -->|デフォルト| J[デフォルト生成器]
    G --> K{フォーマット検証OK?}
    H --> K
    I --> K
    J --> K
    K -->|NG| L[エラー: 無効なフォーマット]
    K -->|OK| M[count回数分UUID生成・出力]
    M --> N[コマンド終了 / 終了コード0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 排他チェック違反 | time-based/name-based/random-basedの複数指定 | 1つの方式のみ指定する |
| 1 | 依存チェック違反 | --nodeをtime-basedなしで指定 | --time-basedオプションと同時指定する |
| 1 | 依存チェック違反 | --namespaceをname-basedなしで指定 | --name-basedオプションと同時指定する |
| 1 | 無効なノード値 | --nodeに不正なUUID文字列を指定 | 有効なUUID文字列を指定する |
| 1 | 無効なタイムスタンプ | --time-basedに不正な日時文字列を指定 | パース可能な日時文字列を指定する |
| 1 | 無効な名前空間 | --namespaceに不正なUUIDまたは未知のキーワードを指定 | 有効なUUIDまたはdns/url/oid/x500を指定する |
| 1 | 無効なフォーマット | --formatにサポート外の値を指定 | rfc4122, base32, base58のいずれかを指定する |
| 1 | 名前空間未設定 | name-basedでnamespaceがファクトリにもオプションにも設定されていない | --namespaceオプションを指定するか、ファクトリのデフォルト名前空間を設定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（対話的コマンドのためリトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ユーティリティコマンドであるため、障害時のリカバリ手順は不要。エラーメッセージに従い入力値を修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | --countオプションの値に依存（デフォルト1件） |
| 目標処理時間 | 1秒以内（countが少数の場合） |
| メモリ使用量上限 | 通常のCLIコマンドの範囲内 |

## 排他制御

UUID生成は状態を変更しないため、排他制御は不要。同時実行も問題なく動作する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | ユーティリティコマンドのため明示的なログ出力なし |
| 進捗ログ | N/A | N/A |
| 終了ログ | N/A | N/A |
| エラーログ | エラー発生時 | SymfonyStyleを通じたエラーメッセージ出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | ユーティリティコマンドのため監視不要 |

## 備考

- 本コマンドはSymfony Uidコンポーネント（`symfony/uid`）の一部として提供される。
- `UuidFactory` はコンストラクタでDI可能であり、デフォルトは `new UuidFactory()` が使用される。
- サポートされる出力フォーマット: `rfc4122`（デフォルト）、`base32`、`base58`。
- 名前空間の定義済みキーワード: `dns`, `url`, `oid`, `x500`。
- エラー出力は `ConsoleOutputInterface::getErrorOutput()` を使用して標準エラー出力に送られ、UUID出力は標準出力に送られるため、パイプ処理でエラーと結果を分離可能。
- コンソール補完機能をサポートしており、`--format` オプションの値が自動補完される。
