# バッチ設計書 65-uuid:inspect

## 概要

本ドキュメントは、Symfonyフレームワークの `uuid:inspect` コマンドに関するバッチ設計書である。指定されたUUIDの詳細情報（バージョン、各種表現形式、タイムスタンプ等）を表示するCLIコマンドの設計を記載する。

### 本バッチの処理概要

`uuid:inspect` コマンドは、引数として受け取ったUUID文字列をパースし、そのバージョン情報、RFC 4122形式、Base58形式、Base32形式、16進形式などの各種表現を表示する。時間ベースのUUIDの場合はタイムスタンプ情報も追加表示する。

**業務上の目的・背景**：UUIDは様々な表現形式（RFC 4122、Base58、Base32等）を持ち、アプリケーション間で異なる形式が使用されることがある。本コマンドは、手元のUUIDがどのバージョンで、どのような情報を含んでいるかを迅速に確認する手段を提供し、デバッグやデータ調査を支援する。

**バッチの実行タイミング**：開発・運用時に手動で随時実行する。UUID解析が必要な場面で利用される。

**主要な処理内容**：
1. 引数としてUUID文字列を受け取る
2. `Uuid::fromString()` でUUIDオブジェクトに変換する
3. UUIDのバージョン（nil, max, または数値バージョン）を判定する
4. 各種表現形式（toRfc4122, toBase58, toBase32, toHex）を取得する
5. 時間ベースUUIDの場合は `getDateTime()` でタイムスタンプを取得する
6. テーブル形式で結果を表示する

**前後の処理との関連**：本コマンドは独立したユーティリティコマンドであり、他のバッチ処理との直接的な依存関係はない。

**影響範囲**：読み取り専用（UUID解析・表示のみ）であり、システムやデータへの影響はない。

## バッチ種別

ユーティリティ / 情報表示

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Uidコンポーネントの有効化 | Symfony Uidコンポーネント（`symfony/uid`）がインストールされていること |

### 実行可否判定

引数に指定されたUUID文字列が不正な場合、`InvalidArgumentException` をキャッチしてエラーメッセージを出力し、終了コード1を返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| uuid | string | Yes | なし | 検査対象のUUID文字列（RFC 4122形式、Base58形式、Base32形式対応） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドライン引数 | 文字列 | ユーザーが入力するUUID文字列 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テーブル形式テキスト | Label / Value の2列テーブル |

### 出力ファイル仕様

ファイル出力はない。標準出力（コンソール）にテーブル形式で結果を表示する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力） |
| 出力先 | コンソール |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（テーブル形式） |

## 処理フロー

### 処理シーケンス

```
1. コマンド実行
   └─ uuid引数を取得
2. UUIDパース
   └─ Uuid::fromString()でUUIDオブジェクトに変換
3. バージョン判定
   └─ NilUuidの場合は"nil"、MaxUuidの場合は"max"、それ以外はRFC 4122文字列の14文字目を数値化
4. 基本情報取得
   └─ Version, toRfc4122 (canonical), toBase58, toBase32, toHexの5項目を取得
5. タイムスタンプ取得（条件付き）
   └─ TimeBasedUidInterfaceを実装している場合、getDateTime()でタイムスタンプを取得
6. 結果出力
   └─ Label / Value の2列テーブルを出力
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B[UUID文字列をパース]
    B --> C{パース成功?}
    C -->|失敗| D[エラーメッセージ出力 / 終了コード1]
    C -->|成功| E[バージョン判定]
    E --> F[基本情報取得]
    F --> G{TimeBasedUid?}
    G -->|はい| H[タイムスタンプ情報追加]
    G -->|いいえ| I[テーブル出力]
    H --> I
    I --> J[コマンド終了 / 終了コード0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | InvalidArgumentException | UUID文字列のパースに失敗 | 有効なUUID文字列を指定する（RFC 4122, Base58, Base32形式対応） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（対話的コマンドのためリトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ユーティリティコマンドであるため、障害時のリカバリ手順は不要。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1UUID/実行 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 通常のCLIコマンドの範囲内 |

## 排他制御

読み取り専用コマンドであるため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | ユーティリティコマンドのため明示的なログ出力なし |
| 進捗ログ | N/A | N/A |
| 終了ログ | N/A | N/A |
| エラーログ | エラー発生時 | SymfonyStyleを通じたエラーメッセージ出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | ユーティリティコマンドのため監視不要 |

## 備考

- 本コマンドはSymfony Uidコンポーネント（`symfony/uid`）の一部として提供される。
- 入力UUIDは以下の形式をサポート: RFC 4122形式（例: `a7613e0a-5986-11eb-a861-2bf05af69e52`）、Base58形式（例: `MfnmaUvvQ1h8B14vTwt6dX`）、Base32形式（例: `57C4Z0MPC627NTGR9BY1DFD7JJ`）。
- NilUUID（全ビットゼロ）とMaxUUID（全ビット1）は特別なバージョン名（"nil", "max"）で表示される。
- 時間ベースUUID（TimeBasedUidInterface実装）の場合、タイムスタンプが `Y-m-d H:i:s.u UTC` 形式で追加表示される。
- エラー出力は `ConsoleOutputInterface::getErrorOutput()` を使用して標準エラー出力に送られる。
