# バッチ設計書 66-ulid:generate

## 概要

本ドキュメントは、Symfonyフレームワークの `ulid:generate` コマンドに関するバッチ設計書である。ULID（Universally Unique Lexicographically Sortable Identifier）を生成するCLIコマンドの設計を記載する。

### 本バッチの処理概要

`ulid:generate` コマンドは、Symfony Uidコンポーネントの `UlidFactory` を使用してULIDを生成し、指定されたフォーマット（base32, base58, rfc4122）で標準出力に出力する。タイムスタンプの指定や複数ULIDの一括生成にも対応する。

**業務上の目的・背景**：ULIDはUUIDの代替として設計された識別子であり、時間順にソート可能かつURL安全な文字列表現を持つ。本コマンドは開発者がCLIから手軽にULIDを生成する手段を提供し、テストデータの作成やスクリプトへの組み込みを支援する。ULIDはタイムスタンプを含むため、生成順序の追跡が容易である。

**バッチの実行タイミング**：開発・運用時に手動で随時実行する。ULID生成が必要な場面で利用される。

**主要な処理内容**：
1. オプション（time, count, format）を取得する
2. `--time` が指定されている場合、DateTimeImmutableに変換する
3. 出力フォーマットの検証を行う
4. `UlidFactory::create()` を使用してULIDを生成する
5. 指定フォーマットで count 回数分標準出力に出力する

**前後の処理との関連**：本コマンドは独立したユーティリティコマンドであり、他のバッチ処理との直接的な依存関係はない。

**影響範囲**：読み取り専用（ULID生成・出力のみ）であり、システムやデータへの影響はない。

## バッチ種別

ユーティリティ / ID生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Uidコンポーネントの有効化 | Symfony Uidコンポーネント（`symfony/uid`）がインストールされていること |

### 実行可否判定

入力値の検証（タイムスタンプの日時パース、フォーマット名のサポート確認）で不正な場合はエラーコード1を返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --time | string | No | なし（現在時刻） | ULIDのタイムスタンプ（パース可能な日時文字列） |
| --count (-c) | int | No | 1 | 生成するULIDの数 |
| --format (-f) | string | No | "base32" | 出力フォーマット（base32, base58, rfc4122） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| UlidFactory | メモリ内オブジェクト | ULID生成ファクトリ（コンストラクタでDI可能） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | プレーンテキスト | 生成されたULID文字列（1行1ULID） |

### 出力ファイル仕様

ファイル出力はない。標準出力にULID文字列を出力する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力） |
| 出力先 | コンソール |
| 文字コード | UTF-8 |
| 区切り文字 | 改行（1ULID1行） |

## 処理フロー

### 処理シーケンス

```
1. オプション取得
   └─ time, count, formatを取得
2. タイムスタンプ処理
   └─ --timeが指定されている場合、DateTimeImmutableに変換（不正ならエラー）
3. フォーマット検証
   └─ base32, base58, rfc4122のいずれかであることを確認（不正ならエラー）
4. ULID生成ループ
   └─ count回数分UlidFactory::create()を呼び出し、指定フォーマットで出力
5. 結果出力
   └─ 各ULIDを1行ずつ標準出力に出力
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B{--time指定あり?}
    B -->|あり| C[DateTimeImmutableに変換]
    C --> D{変換成功?}
    D -->|失敗| E[エラー: 無効なタイムスタンプ / 終了コード1]
    D -->|成功| F{フォーマット検証}
    B -->|なし| F
    F -->|無効| G[エラー: 無効なフォーマット / 終了コード1]
    F -->|有効| H[count回数分ULID生成・出力]
    H --> I{生成中にエラー?}
    I -->|あり| J[エラーメッセージ出力 / 終了コード1]
    I -->|なし| K[コマンド終了 / 終了コード0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 無効なタイムスタンプ | --timeに不正な日時文字列を指定 | パース可能な日時文字列を指定する |
| 1 | 無効なフォーマット | --formatにサポート外の値を指定 | base32, base58, rfc4122のいずれかを指定する |
| 1 | ULID生成エラー | UlidFactory::create()で例外発生 | エラーメッセージに従い入力値を修正する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（対話的コマンドのためリトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ユーティリティコマンドであるため、障害時のリカバリ手順は不要。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | --countオプションの値に依存（デフォルト1件） |
| 目標処理時間 | 1秒以内（countが少数の場合） |
| メモリ使用量上限 | 通常のCLIコマンドの範囲内 |

## 排他制御

ULID生成は状態を変更しないため、排他制御は不要。同時実行も問題なく動作する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | ユーティリティコマンドのため明示的なログ出力なし |
| 進捗ログ | N/A | N/A |
| 終了ログ | N/A | N/A |
| エラーログ | エラー発生時 | SymfonyStyleを通じたエラーメッセージ出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | ユーティリティコマンドのため監視不要 |

## 備考

- 本コマンドはSymfony Uidコンポーネント（`symfony/uid`）の一部として提供される。
- `UlidFactory` はコンストラクタでDI可能であり、デフォルトは `new UlidFactory()` が使用される。
- サポートされる出力フォーマット: `base32`（デフォルト）、`base58`、`rfc4122`。UUIDの `uuid:generate` コマンドとはデフォルトフォーマットが異なる（ULIDはbase32がデフォルト）。
- エラー出力は `ConsoleOutputInterface::getErrorOutput()` を使用して標準エラー出力に送られ、ULID出力は標準出力に送られるため、パイプ処理でエラーと結果を分離可能。
- コンソール補完機能をサポートしており、`--format` オプションの値が自動補完される。
