# バッチ設計書 67-ulid:inspect

## 概要

本ドキュメントは、Symfonyフレームワークの `ulid:inspect` コマンドに関するバッチ設計書である。指定されたULIDの詳細情報（各種表現形式、タイムスタンプ等）を表示するCLIコマンドの設計を記載する。

### 本バッチの処理概要

`ulid:inspect` コマンドは、引数として受け取ったULID文字列をパースし、Base32形式（標準表現）、Base58形式、RFC 4122形式、16進形式の各種表現と、ULIDに埋め込まれたタイムスタンプを表示する。ULIDは常にタイムスタンプを含むため、必ず時刻情報が表示される。

**業務上の目的・背景**：ULIDは複数の表現形式（Base32、Base58、RFC 4122等）を持ち、アプリケーション間で異なる形式が使用されることがある。本コマンドは、手元のULIDがどのような情報を含んでいるか、特にタイムスタンプ（生成時刻）を迅速に確認する手段を提供し、デバッグやデータ調査を支援する。

**バッチの実行タイミング**：開発・運用時に手動で随時実行する。ULID解析が必要な場面で利用される。

**主要な処理内容**：
1. 引数としてULID文字列を受け取る
2. `Ulid::fromString()` でULIDオブジェクトに変換する
3. 各種表現形式（toBase32, toBase58, toRfc4122, toHex）を取得する
4. `getDateTime()` でタイムスタンプを取得する
5. テーブル形式で結果を表示する

**前後の処理との関連**：本コマンドは独立したユーティリティコマンドであり、他のバッチ処理との直接的な依存関係はない。

**影響範囲**：読み取り専用（ULID解析・表示のみ）であり、システムやデータへの影響はない。

## バッチ種別

ユーティリティ / 情報表示

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Uidコンポーネントの有効化 | Symfony Uidコンポーネント（`symfony/uid`）がインストールされていること |

### 実行可否判定

引数に指定されたULID文字列が不正な場合、`InvalidArgumentException` をキャッチしてエラーメッセージを出力し、終了コード1を返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ulid | string | Yes | なし | 検査対象のULID文字列（Base32形式、Base58形式、RFC 4122形式対応） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドライン引数 | 文字列 | ユーザーが入力するULID文字列 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テーブル形式テキスト | Label / Value の2列テーブル（6行） |

### 出力ファイル仕様

ファイル出力はない。標準出力（コンソール）にテーブル形式で結果を表示する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力） |
| 出力先 | コンソール |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（テーブル形式） |

## 処理フロー

### 処理シーケンス

```
1. コマンド実行
   └─ ulid引数を取得
2. ULIDパース
   └─ Ulid::fromString()でULIDオブジェクトに変換
3. 各種表現形式取得
   └─ toBase32 (canonical), toBase58, toRfc4122, toHexの4項目を取得
4. タイムスタンプ取得
   └─ getDateTime()でタイムスタンプを取得（ミリ秒精度）
5. 結果出力
   └─ Label / Value の2列テーブルを出力（セパレータ付き）
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B[ULID文字列をパース]
    B --> C{パース成功?}
    C -->|失敗| D[エラーメッセージ出力 / 終了コード1]
    C -->|成功| E[各種表現形式を取得]
    E --> F[タイムスタンプを取得]
    F --> G[テーブル出力]
    G --> H[コマンド終了 / 終了コード0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | InvalidArgumentException | ULID文字列のパースに失敗 | 有効なULID文字列を指定する（Base32, Base58, RFC 4122形式対応） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（対話的コマンドのためリトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ユーティリティコマンドであるため、障害時のリカバリ手順は不要。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ULID/実行 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 通常のCLIコマンドの範囲内 |

## 排他制御

読み取り専用コマンドであるため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | ユーティリティコマンドのため明示的なログ出力なし |
| 進捗ログ | N/A | N/A |
| 終了ログ | N/A | N/A |
| エラーログ | エラー発生時 | SymfonyStyleを通じたエラーメッセージ出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | ユーティリティコマンドのため監視不要 |

## 備考

- 本コマンドはSymfony Uidコンポーネント（`symfony/uid`）の一部として提供される。
- 入力ULIDは以下の形式をサポート: Base32形式（例: `01EWAKBCMWQ2C94EXNN60ZBS0Q`）、Base58形式（例: `1BVdfLn3ERmbjYBLCdaaLW`）、RFC 4122形式（例: `01771535-b29c-b898-923b-b5a981f5e417`）。
- ULIDは常にタイムスタンプを含むため、`uuid:inspect` コマンドとは異なり、タイムスタンプ情報は常に表示される（条件分岐なし）。
- タイムスタンプのフォーマットは `Y-m-d H:i:s.v UTC`（ミリ秒精度）。UUIDのタイムスタンプ表示（`Y-m-d H:i:s.u UTC`、マイクロ秒精度）とは異なる。
- エラー出力は `ConsoleOutputInterface::getErrorOutput()` を使用して標準エラー出力に送られる。
- 表示テーブルにはTableSeparatorが含まれ、基本情報とタイムスタンプ情報が視覚的に分離される。
