# バッチ設計書 68-debug:validator

## 概要

本ドキュメントは、Symfonyフレームワークの `debug:validator` コマンドに関するバッチ設計書である。指定されたクラスまたはディレクトリ内のクラスに対するバリデーション制約（Constraints）を一覧表示するCLIコマンドの設計を記載する。

### 本バッチの処理概要

`debug:validator` コマンドは、Symfony Validatorコンポーネントの `MetadataFactoryInterface` を使用して、指定クラスのバリデーションメタデータ（制約一覧、グループ、オプション、カスケード/トラバーサル戦略など）を取得し、テーブル形式で表示する。クラス名の代わりにディレクトリパスを指定して、ディレクトリ内の全クラスの制約を一括表示することも可能。

**業務上の目的・背景**：Symfonyアプリケーションにおいて、バリデーション制約はアノテーション、PHPアトリビュート、YAML、XMLなど多様な方法で定義される。これらの設定が分散しているため、特定クラスに適用される最終的なバリデーション構成を一覧確認する手段が必要である。本コマンドはバリデーション設定のデバッグと確認を支援し、設定ミスの早期発見に役立てる。

**バッチの実行タイミング**：開発時に手動で随時実行する。バリデーション設定の確認やデバッグ時に利用される。

**主要な処理内容**：
1. 引数として完全修飾クラス名またはディレクトリパスを受け取る
2. クラス名の場合は直接メタデータを取得して表示する
3. ディレクトリパスの場合はFinderで.phpファイルを走査し、各クラスのメタデータを取得して表示する
4. クラスレベルの制約とプロパティレベルの制約を分離して表示する
5. 各制約のクラス名、グループ、オプションをテーブル形式で出力する
6. プロパティにはcascadeStrategy、autoMappingStrategy、traversalStrategyの情報も表示する

**前後の処理との関連**：本コマンドは読み取り専用のデバッグコマンドであり、他のバッチ処理の前提条件や後続処理としての依存関係はない。

**影響範囲**：読み取り専用のため、システムやデータへの影響はない。Validatorコンポーネントの `MetadataFactoryInterface` の実装に依存する。

## バッチ種別

デバッグ / 情報表示

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Validatorコンポーネントの有効化 | Symfony Validatorコンポーネントがインストールされていること |
| MetadataFactoryの登録 | `MetadataFactoryInterface` がサービスコンテナに登録されていること |

### 実行可否判定

引数がクラス名でもディレクトリパスでもない場合（クラスが存在せず、ディレクトリも見つからない場合）、「Neither class nor path were found」エラーを出力して終了コード1を返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| class | string | Yes | なし | 完全修飾クラス名またはディレクトリパス |
| --show-all | bool | No | false | バリデーション制約のないクラスも表示する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| MetadataFactoryInterface | メモリ内オブジェクト | クラスのバリデーションメタデータを提供するファクトリ |
| ファイルシステム | PHPファイル | ディレクトリ指定時のクラスファイル走査 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テーブル形式テキスト | Property / Name / Groups / Options の4列テーブル |

### 出力ファイル仕様

ファイル出力はない。標準出力（コンソール）にテーブル形式で結果を表示する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力） |
| 出力先 | コンソール |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（テーブル形式） |

## 処理フロー

### 処理シーケンス

```
1. コマンド実行
   └─ class引数と--show-allオプションを取得
2. 入力種別判定
   └─ class_exists()でクラス名かどうか判定
3a. クラス名の場合
   └─ 直接dumpValidatorsForClass()を呼び出して表示
3b. ディレクトリパスの場合
   └─ Finderで*.phpファイルを走査
   └─ 各ファイルからnamespaceとclass名を正規表現で抽出
   └─ 各クラスに対してdumpValidatorsForClass()を呼び出す
4. メタデータ取得
   └─ MetadataFactoryInterface::getMetadataFor()でクラスメタデータを取得
5. クラスレベル制約の抽出
   └─ getConstraints()でクラスレベルの制約を取得（Propertyは"-"）
6. プロパティレベル制約の抽出
   └─ getConstrainedProperties()で制約付きプロパティ一覧を取得
   └─ 各プロパティのcascadeStrategy, autoMappingStrategy, traversalStrategyを取得
   └─ 各プロパティの制約一覧を取得
7. 結果出力
   └─ Property / Name / Groups / Options の4列テーブルを出力
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B{class_exists?}
    B -->|はい| C[直接メタデータ取得・表示]
    B -->|いいえ| D[Finderでディレクトリ走査]
    D --> E{ディレクトリ存在?}
    E -->|なし| F[エラー: Neither class nor path / 終了コード1]
    E -->|あり| G[各クラスのメタデータ取得・表示]
    C --> H{制約あり?}
    G --> H
    H -->|なし / show-all=false| I[スキップ]
    H -->|なし / show-all=true| J[No validators メッセージ表示]
    H -->|あり| K[Property/Name/Groups/Options テーブル出力]
    I --> L[コマンド終了 / 終了コード0]
    J --> L
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | DirectoryNotFoundException | 引数がクラス名でもディレクトリパスでもない | 有効なFQCNまたはディレクトリパスを指定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（対話的コマンドのためリトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

読み取り専用のデバッグコマンドであるため、障害時のリカバリ手順は不要。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1クラスまたはディレクトリ内の全クラス（ディレクトリのサイズに依存） |
| 目標処理時間 | クラス指定: 1秒以内、ディレクトリ指定: ファイル数に依存 |
| メモリ使用量上限 | 通常のCLIコマンドの範囲内 |

## 排他制御

読み取り専用コマンドであるため、排他制御は不要。同時実行も問題なく動作する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | デバッグコマンドのため明示的なログ出力なし |
| 進捗ログ | N/A | N/A |
| 終了ログ | N/A | N/A |
| エラーログ | エラー発生時 | SymfonyStyleを通じたエラーメッセージ出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | デバッグコマンドのため監視不要 |

## 備考

- 本コマンドはSymfony Validatorコンポーネント（`symfony/validator`）の一部として提供される。
- テーブルの4列目（Options）の最大幅は80文字に制限されている（`setColumnMaxWidth(3, 80)`）。
- クラスレベルの制約はPropertyカラムに「-」が表示される。
- プロパティレベルの情報には以下の戦略情報が含まれる:
  - cascadeStrategy: `Cascade` または `None`
  - autoMappingStrategy: `Enabled`, `Disabled`, `None`, または `Not supported`
  - traversalStrategy: `Traverse`, `Implicit`, または `None`
- ディレクトリ走査時は `Symfony\Component\Finder\Finder` を使用し、ファイル名順にソートされる。
- 名前空間の抽出は正規表現 `/namespace (.+);/` を使用し、クラス名の抽出は `/class +([^{ ]+)/` を使用する。
- 出力にはConsole Helperの `Dumper` クラスが使用され、オプション値が見やすくフォーマットされる。
- 作者: Loic Fremont
