# バッチ設計書 69-workflow:dump

## 概要

本ドキュメントは、Symfonyフレームワークの `workflow:dump` コマンドに関するバッチ設計書である。ワークフローまたはステートマシンの定義をグラフィカルな表現形式（DOT, PlantUML, Mermaid）でダンプするCLIコマンドの設計を記載する。

### 本バッチの処理概要

`workflow:dump` コマンドは、指定されたワークフロー名に対応する `Workflow` または `StateMachine` オブジェクトの定義を取得し、指定されたダンプ形式（dot, puml, mermaid）でグラフィカルな表現を標準出力に出力する。出力結果をGraphviz、PlantUML、Mermaid CLIなどの外部ツールにパイプすることで、ワークフローの視覚的な図を生成できる。

**業務上の目的・背景**：Symfonyのワークフローコンポーネントは、ビジネスプロセスやステートマシンをコードで定義する機能を提供する。定義が複雑になると、プレース（状態）やトランジション（遷移）の全体像を把握することが困難になる。本コマンドは、ワークフロー定義をグラフィカルな形式でダンプすることで、設計の可視化・レビュー・ドキュメント化を支援する。

**バッチの実行タイミング**：開発・運用時に手動で随時実行する。ワークフロー定義の可視化やドキュメント生成時に利用される。

**主要な処理内容**：
1. ワークフロー名（必須引数）を受け取る
2. ServiceProviderからワークフローオブジェクトを取得する
3. TraceableWorkflowの場合は内部のワークフローを取得する
4. ワークフローの種別（workflow/state_machine）を判定する
5. ダンプ形式に応じたダンパー（GraphvizDumper, PlantUmlDumper, MermaidDumper）を生成する
6. marking引数からマーキング（現在の状態）を設定する
7. ラベル、メタデータ表示などのオプションを設定してダンプ結果を出力する

**前後の処理との関連**：本コマンドは読み取り専用のコマンドであり、他のバッチ処理の前提条件や後続処理としての依存関係はない。出力結果は外部ツール（dot, plantuml, mmdc）へのパイプで使用される。

**影響範囲**：読み取り専用のため、システムやデータへの影響はない。Workflowコンポーネントの定義に依存する。

## バッチ種別

ユーティリティ / ドキュメント生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Workflowコンポーネントの有効化 | Symfony Workflowコンポーネント（`symfony/workflow`）がインストールされていること |
| ワークフロー定義の登録 | 1つ以上のワークフローがServiceProviderに登録されていること |

### 実行可否判定

指定されたワークフロー名がServiceProviderに存在しない場合、`InvalidArgumentException` を投げて終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| name | string | Yes | なし | ワークフロー名 |
| marking | string[] | No | 空配列 | マーキング（現在の状態を示すプレースのリスト） |
| --label (-l) | string | No | なし | グラフのラベル |
| --with-metadata | bool | No | false | ワークフローのメタデータをダンプに含める |
| --dump-format | string | No | "dot" | ダンプ形式（dot, puml, mermaid） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ServiceProviderInterface (workflows) | メモリ内オブジェクト | コンテナに登録されたワークフローのコレクション |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | プレーンテキスト | DOT, PlantUML, またはMermaid形式のグラフ定義 |

### 出力ファイル仕様

ファイル出力はない。標準出力にグラフ定義テキストを出力する。パイプで外部ツールに渡すことで画像ファイルを生成可能。

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力、パイプで外部ツールに渡す） |
| 出力先 | コンソール |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. コマンド実行
   └─ name引数、marking引数、各オプションを取得
2. ワークフロー取得
   └─ ServiceProviderからワークフロー名で取得
   └─ TraceableWorkflowの場合はgetInner()で内部ワークフローを取得
3. 種別判定
   └─ StateMachineインスタンスの場合は"state_machine"、それ以外は"workflow"
4. ワークフロー定義取得
   └─ getDefinition()でWorkflowDefinitionを取得
5. ダンパー生成
   └─ dump-formatに応じてGraphvizDumper/PlantUmlDumper/MermaidDumperを生成
   └─ StateMachineの場合は対応するトランジションタイプを設定
6. マーキング設定
   └─ marking引数からMarkingオブジェクトを生成
7. ダンプ実行
   └─ dumper->dump()にdefinition, marking, optionsを渡してグラフ定義を生成
8. 結果出力
   └─ 生成されたグラフ定義を標準出力に出力
```

### フローチャート

```mermaid
flowchart TD
    A[コマンド開始] --> B{ワークフロー存在?}
    B -->|なし| C[InvalidArgumentException]
    B -->|あり| D[ワークフロー取得]
    D --> E{TraceableWorkflow?}
    E -->|はい| F[getInner()で内部取得]
    E -->|いいえ| G[種別判定]
    F --> G
    G --> H{dump-format}
    H -->|puml| I[PlantUmlDumper生成]
    H -->|mermaid| J[MermaidDumper生成]
    H -->|dot| K[GraphvizDumper生成]
    I --> L[マーキング設定]
    J --> L
    K --> L
    L --> M[ダンプ実行・出力]
    M --> N[コマンド終了 / 終了コード0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidArgumentException | 指定ワークフロー名が未登録 | 有効なワークフロー名を指定する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（対話的コマンドのためリトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ユーティリティコマンドであるため、障害時のリカバリ手順は不要。エラーが発生した場合は、ワークフロー名の正確性やコンテナ設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（データベース操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ワークフロー/実行 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 通常のCLIコマンドの範囲内（ワークフローの複雑さに依存） |

## 排他制御

読み取り専用コマンドであるため、排他制御は不要。同時実行も問題なく動作する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | ユーティリティコマンドのため明示的なログ出力なし |
| 進捗ログ | N/A | N/A |
| 終了ログ | N/A | N/A |
| エラーログ | エラー発生時 | InvalidArgumentExceptionのメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | ユーティリティコマンドのため監視不要 |

## 備考

- 本コマンドはSymfony Workflowコンポーネント（`symfony/workflow`）の一部として提供される。
- サポートされるダンプ形式（`--dump-format`）:
  - `dot`（デフォルト）: Graphviz DOT形式。`| dot -Tpng > workflow.png` でPNG画像生成可能。
  - `puml`: PlantUML形式。`| java -jar plantuml.jar -p > workflow.png` で画像生成可能。
  - `mermaid`: Mermaid形式。`| mmdc -o workflow.svg` でSVG画像生成可能。
- StateMachineの場合、DOT形式では `StateMachineGraphvizDumper` が使用され、PlantUML/Mermaidでは対応するトランジションタイプが設定される。
- `--with-metadata` オプションを使用すると、ワークフローのメタデータ（プレース・トランジションに付与されたカスタムデータ）がグラフに含まれる。
- ダンプオプションに `nofooter: true` が設定され、フッターなしでグラフが生成される。
- `TraceableWorkflow`（デバッグ用ラッパー）が渡された場合、自動的に内部のワークフローを取得して処理する。
- コンソール補完機能をサポートしており、`name` 引数および `--dump-format` オプションの値が自動補完される。
- 作者: Gregoire Pineau
