# バッチ設計書 7-cache:pool:invalidate-tags

## 概要

本ドキュメントは、Symfonyフレームワークが提供する `cache:pool:invalidate-tags` コンソールコマンドのバッチ設計書である。タグ付きキャッシュプールにおいて、指定されたキャッシュタグを無効化する処理の仕様を定義する。

### 本バッチの処理概要

`cache:pool:invalidate-tags` コマンドは、`TagAwareCacheInterface` を実装するキャッシュプールに対して、指定されたタグに関連するキャッシュエントリを無効化する機能を提供する。

**業務上の目的・背景**：タグベースのキャッシュ管理を行うアプリケーションにおいて、特定のタグに関連する全てのキャッシュを一括で無効化する必要がある場合に使用する。例えば、商品マスタが更新された場合に「product」タグの付いた全キャッシュを無効化する、ユーザー情報が変更された場合に「user」タグの全キャッシュを無効化するといったユースケースに対応する。キャッシュキーを個別に管理する必要がなく、タグによる論理的なグルーピングでキャッシュの無効化を効率的に行える。

**バッチの実行タイミング**：データの一括更新後、マスタデータ変更後など、特定カテゴリのキャッシュを一括無効化する必要が生じた場合に随時実行される。

**主要な処理内容**：
1. 引数から無効化対象のタグリストを取得
2. `--pool` オプションで対象プールを限定、未指定時は全タグ対応プールを対象
3. ServiceProviderInterfaceから各プールインスタンスを取得
4. プールがTagAwareCacheInterfaceを実装しているか確認
5. 各プールに対して `invalidateTags()` を呼び出し
6. エラーが発生したプールについてはエラーメッセージを出力

**前後の処理との関連**：`cache:pool:clear` がプール全体をクリアするのに対し、本コマンドは特定タグに関連するエントリのみを無効化する、より粒度の細かいキャッシュ管理を提供する。

**影響範囲**：指定されたタグに関連付けられたキャッシュエントリのみが無効化される。タグに関連しないキャッシュエントリは影響を受けない。

## バッチ種別

キャッシュ管理 / メンテナンスコマンド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / スクリプト / イベント駆動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| タグの指定 | 1つ以上のタグ名が必須引数として必要 |
| タグ対応プールの存在 | TagAwareCacheInterfaceを実装するプールがServiceProviderに登録されている |

### 実行可否判定

タグ引数は必須であり、未指定の場合はSymfony Consoleフレームワークによりエラーが返される。対象プールが見つからない場合やTagAwareCacheInterfaceを実装していない場合は、エラーメッセージが出力される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| tags | string[] | Yes | なし | 無効化するキャッシュタグのリスト |
| --pool / -p | string[] | No | 全プール | 無効化対象のプール名リスト（複数指定可） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ServiceProviderInterface (pools) | サービス | TagAwareCacheInterface実装プールのサービスプロバイダー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stdout | テキスト | 各プールのタグ無効化進捗メッセージおよび結果メッセージ |

### 出力ファイル仕様

該当なし

## 処理フロー

### 処理シーケンス

```
1. 引数・オプション解析
   └─ tags引数と--poolオプションを取得
2. 対象プール決定
   └─ --pool指定時はそのプール名、未指定時は全登録プール名
3. 各プール処理
   └─ ServiceProviderからプールインスタンスを取得
4. プール型チェック
   └─ TagAwareCacheInterfaceを実装しているか確認
5. タグ無効化実行
   └─ invalidateTags()で指定タグを無効化
6. 結果出力
   └─ エラーがあればエラーメッセージ、なければ成功メッセージ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tags引数と--poolオプション取得]
    B --> C{--pool指定あり?}
    C -->|Yes| D[指定プール名を使用]
    C -->|No| E[全登録プール名を使用]
    D --> F[各プールを処理]
    E --> F
    F --> G{次のプールあり?}
    G -->|Yes| H[ServiceProviderからプール取得]
    G -->|No| I{エラーあり?}
    H --> J{プール取得成功?}
    J -->|No| K[エラー: Pool not found]
    J -->|Yes| L{TagAwareCacheInterface?}
    L -->|No| M[エラー: Pool is not taggable]
    L -->|Yes| N[invalidateTags実行]
    N --> O{無効化成功?}
    O -->|Yes| G
    O -->|No| P[エラー: Could not invalidate]
    K --> Q[エラーフラグ設定]
    M --> Q
    P --> Q
    Q --> G
    I -->|Yes| R[エラーメッセージ出力・終了コード1]
    I -->|No| S[成功メッセージ出力・終了コード0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本コマンドはデータベースに対する直接的な操作を行わない。タグ無効化の実際の処理はキャッシュアダプターの実装に依存する。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | キャッシュバックエンド依存 |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード1 | プール未発見 | ServiceProviderに指定プール名が存在しない（ServiceNotFoundException） | 正しいプール名を指定する |
| 終了コード1 | 型不一致 | プールがTagAwareCacheInterfaceを実装していない | タグ対応のプールを指定する |
| 終了コード1 | 無効化失敗 | `invalidateTags()` がfalseを返した場合 | キャッシュバックエンドの状態を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. プール未発見の場合は、利用可能なプール名を確認する。
2. TagAwareCacheInterfaceを実装していないプールの場合、`cache:pool:clear` を代替として使用する。
3. invalidateTagsに失敗した場合、キャッシュバックエンドの接続・状態を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各プール単位で独立 |
| コミットタイミング | 各プールのinvalidateTags()完了時 |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | タグ対応プール数 x タグ数 |
| 目標処理時間 | プール数とタグ数に依存 |
| メモリ使用量上限 | 通常低い |

## 排他制御

各プールの `invalidateTags()` メソッドの排他制御は、キャッシュアダプターの実装に依存する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各プール処理時 | `Invalidating tag(s): {tags} from pool {name}.` |
| エラーログ | プール未発見時 | `Pool "{name}" not found.` |
| エラーログ | タグ非対応時 | `Pool "{name}" is not taggable.` |
| エラーログ | 無効化失敗時 | `Cache tag(s) "{tags}" could not be invalidated for pool "{name}".` |
| エラーログ | エラーあり終了時 | `Done but with errors.` |
| 終了ログ | 全成功時 | `Successfully invalidated cache tags.` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 運用監視システム |

## 備考

- シェル補完機能をサポートしており、`--pool` オプションの入力時にプール名候補が表示される。
- プール名はコンストラクタで注入される `ServiceProviderInterface` から `getProvidedServices()` で取得される。
- ServiceNotFoundExceptionはtry-catchで捕捉され、エラーメッセージとして出力される（例外はスローされない）。
- 複数プールの処理中にエラーが発生しても、残りのプールの処理は継続される。
- ソースコード: `src/Symfony/Bundle/FrameworkBundle/Command/CachePoolInvalidateTagsCommand.php`
