---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：1-cache_clear.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足（閾値は推定値）
  2. **監視・アラート閾値**：根拠不足（環境依存のため具体値なし）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/CacheClearCommand.php` - メインソースコード
- E-02: `CacheClearCommand::configure()` メソッド（L51-67）- コマンド定義・オプション
- E-03: `CacheClearCommand::execute()` メソッド（L69-205）- メイン処理ロジック
- E-04: `CacheClearCommand::isNfs()` メソッド（L207-230）- NFS判定ロジック
- E-05: `CacheClearCommand::warmup()` メソッド（L232-240）- ウォームアップ処理
- E-06: `CacheClearCommand::warmupOptionals()` メソッド（L242-253）- オプショナルウォーマー処理
- E-07: `#[AsCommand]` アトリビュート（L37）- コマンド名・説明
- E-08: コンストラクタ（L42-49）- 依存性注入（CacheClearerInterface, Filesystem）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `cache:clear` である | E-07 | ○ |
| C-02 | `--no-warmup` オプションでウォームアップをスキップできる | E-02 | ○ |
| C-03 | `--no-optional-warmers` オプションでオプショナルウォーマーをスキップできる | E-02 | ○ |
| C-04 | キャッシュディレクトリの書き込み権限を確認する | E-03 (L82-84) | ○ |
| C-05 | ビルドディレクトリの書き込み権限を確認する | E-03 (L91-93) | ○ |
| C-06 | NFS環境ではディレクトリをリネームではなく削除する | E-03 (L95-99), E-04 | ○ |
| C-07 | CacheClearerInterfaceを通じてキャッシュをクリアする | E-03 (L105-107), E-08 | ○ |
| C-08 | EventDispatcherを新しいインスタンスに置換する | E-03 (L110) | ○ |
| C-09 | キャッシュ鮮度判定をコンテナファイルのタイムスタンプで行う | E-03 (L124) | ○ |
| C-10 | ウォームアップはカーネルリブートで行う | E-05 (L236-239) | ○ |
| C-11 | RebootableInterface未実装時にLogicExceptionをスローする | E-05 (L236-238) | ○ |
| C-12 | ウォームアップディレクトリ名は本番と同じ長さに保たれる | E-03 (L115-117) | ○ |
| C-13 | ファイル内のパス参照を置換する | E-03 (L151-158) | ○ |
| C-14 | アトミックリネームでキャッシュを切り替える | E-03 (L173) | ○ |
| C-15 | 古いディレクトリ削除失敗時はIOExceptionをキャッチして警告出力 | E-03 (L182-195) | ○ |
| C-16 | NFS判定は `/proc/mounts` を参照する | E-04 (L213) | ○ |
| C-17 | オプショナルウォーマーはpreloadファイルを更新する | E-06 (L250-252) | ○ |
| C-18 | CacheClearerInterfaceとFilesystemが依存注入される | E-08 | ○ |
| C-19 | パフォーマンス要件は通常数秒〜数十秒 | **根拠なし** | △ |
| C-20 | 監視閾値は通常60秒以上で警告 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値はソースコードに定義されていない。実行環境やアプリケーション規模に依存するため推定値として記載した。
  - 候補：実運用環境でのベンチマーク結果 / Symfonyドキュメント / プロジェクト固有の性能要件定義書
- 監視・アラートの閾値はプロジェクト固有の設定であり、フレームワーク側では定義されていない。
  - 候補：プロジェクト運用マニュアル / 監視設定ファイル / インフラ設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンド名・オプション・処理フローはソースコードから直接確認可能
- 1: 中リスク - パフォーマンス要件・監視閾値は推定値であり、プロジェクト固有の値に置き換える必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] 処理フローがソースコードの `execute()` メソッドの実装と一致しているか
- [ ] 入力パラメータの定義が `configure()` メソッドと一致しているか
- [ ] エラーケースの網羅性が十分か
- [ ] パフォーマンス要件・監視閾値をプロジェクト固有の値に更新する必要があるか
