---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-secrets_reveal.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsRevealCommand.php` 26行目 - AsCommandアトリビュート（コマンド名・説明）
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsRevealCommand.php` 29-34行目 - コンストラクタ（AbstractVault, localVault依存）
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsRevealCommand.php` 39行目 - addArgument（name引数、REQUIRED、補完機能）
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsRevealCommand.php` 53-54行目 - vault->list(true), localVault->list(true)
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsRevealCommand.php` 58-59行目 - ローカルVault優先ロジック
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsRevealCommand.php` 61-64行目 - シークレット未登録エラー
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsRevealCommand.php` 65-68行目 - 復号失敗エラー（null判定）
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsRevealCommand.php` 71行目 - メインVault値の出力
- E-09: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsRevealCommand.php` 51行目 - SymfonyStyle + ConsoleOutputInterface判定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が secrets:reveal である | E-01 | ○ |
| C-02 | コマンドの説明が「Reveal the value of a secret」である | E-01 | ○ |
| C-03 | AbstractVaultとオプショナルなlocalVaultを依存として受け取る | E-02 | ○ |
| C-04 | name引数が必須（REQUIRED）である | E-03 | ○ |
| C-05 | シェル補完でVault内のシークレット名一覧が候補として表示される | E-03 | ○ |
| C-06 | メインVaultとローカルVaultの両方から復号付きリストを取得する | E-04 | ○ |
| C-07 | ローカルVaultに該当シークレットが存在する場合はローカル値が優先される | E-05 | ○ |
| C-08 | シークレットが存在しない場合にINVALIDを返す | E-06 | ○ |
| C-09 | 復号に失敗した場合（null）にINVALIDを返す | E-07 | ○ |
| C-10 | 正常時はSUCCESSを返す | E-08 | ○ |
| C-11 | エラーメッセージ「The secret "{name}" does not exist.」を出力する | E-06 | ○ |
| C-12 | エラーメッセージ「The secret "{name}" could not be decrypted.」を出力する | E-07 | ○ |
| C-13 | ConsoleOutputInterfaceの場合はErrorOutputを使用する | E-09 | ○ |
| C-14 | データベース操作は行わない（読み取り専用） | E-01〜E-09（DB操作コード不在） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ローカルVault優先ロジックの記述がソースコードと一致しているか確認
- [ ] エラーメッセージの記述がソースコードの文字列と完全に一致しているか確認
- [ ] 入力パラメータの必須/任意の記述が正しいか確認
