---
generated_at: 2026-02-04 10:01:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-secrets_generate-keys.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsGenerateKeysCommand.php` 30行目 - AsCommandアトリビュート
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsGenerateKeysCommand.php` 33-37行目 - コンストラクタ
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsGenerateKeysCommand.php` 43行目 - --local オプション定義
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsGenerateKeysCommand.php` 44行目 - --rotate オプション定義
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsGenerateKeysCommand.php` 63行目 - --localによるVault切り替え
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsGenerateKeysCommand.php` 65-69行目 - ローカルVault無効エラー
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsGenerateKeysCommand.php` 71-85行目 - 通常モード（rotate なし）
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsGenerateKeysCommand.php` 87-96行目 - ローテーション：全シークレット読み出し
- E-09: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsGenerateKeysCommand.php` 98-102行目 - generateKeys(true)
- E-10: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsGenerateKeysCommand.php` 106-109行目 - 再暗号化ループ（seal）
- E-11: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsGenerateKeysCommand.php` 76行目, 114-116行目 - 復号キーコミット警告

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が secrets:generate-keys である | E-01 | ○ |
| C-02 | --local (-l) オプションでローカルVaultを対象にできる | E-03, E-05 | ○ |
| C-03 | --rotate (-r) オプションで既存キーのローテーションができる | E-04, E-08 | ○ |
| C-04 | ローカルVaultがnullの場合にエラーを返す | E-06 | ○ |
| C-05 | 通常モードでgenerateKeysを呼び出す | E-07 | ○ |
| C-06 | generateKeys成功時に成功メッセージを表示する | E-07 | ○ |
| C-07 | generateKeys失敗時に警告メッセージを表示する | E-07 | ○ |
| C-08 | ローテーション時に全シークレットを復号して読み出す | E-08 | ○ |
| C-09 | 復号失敗（null値）でエラー終了する | E-08 | ○ |
| C-10 | generateKeys(true)で強制キー生成を行う | E-09 | ○ |
| C-11 | 全シークレットをsealで再暗号化する | E-10 | ○ |
| C-12 | ローテーション完了メッセージを表示する | E-10 | ○ |
| C-13 | メインVaultの場合に復号キーコミット警告を表示する | E-11 | ○ |
| C-14 | エラー時の戻り値が1である | E-06, E-07, E-08 | ○ |
| C-15 | 正常時の戻り値が0である | E-07 | ○ |
| C-16 | ローカルVault無効時のエラーメッセージが「The local vault is disabled.」 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] キーローテーション処理の順序（読み出し→キー生成→再暗号化）が正しいか確認
- [ ] エラーハンドリングの記述がソースコードと一致しているか確認
- [ ] --local / --rotate オプションの組み合わせによる動作が正しく記述されているか確認
