---
generated_at: 2026-02-04 10:02:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-secrets_decrypt-to-local.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` 28行目 - AsCommandアトリビュート
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` 31-36行目 - コンストラクタ
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` 41行目 - --force オプション定義
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` 59-63行目 - ローカルVault有効性チェック
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` 65行目 - vault->list(true)
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` 67行目 - シークレット数コメント出力
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` 70-77行目 - 重複チェックロジック
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` 79-84行目 - スキップ警告メッセージ
- E-09: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` 87-96行目 - シークレットコピーループ
- E-10: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` 88-92行目 - 復号失敗エラーハンドリング
- E-11: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` 94-95行目 - seal + note出力
- E-12: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsDecryptToLocalCommand.php` 98-103行目 - hadErrorsによる戻り値制御

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が secrets:decrypt-to-local である | E-01 | ○ |
| C-02 | --force (-f) オプションで既存シークレットの上書きが可能 | E-03, E-07 | ○ |
| C-03 | ローカルVaultがnullの場合にエラーを返す | E-04 | ○ |
| C-04 | メインVaultから全シークレットを復号付きで取得する | E-05 | ○ |
| C-05 | シークレット数をコメントとして出力する | E-06 | ○ |
| C-06 | --forceなしの場合にローカルVaultの既存シークレットをスキップする | E-07 | ○ |
| C-07 | スキップ数がある場合に警告メッセージを表示する | E-08 | ○ |
| C-08 | 復号値がnullの場合にエラーを出力してスキップする | E-10 | ○ |
| C-09 | localVault->sealでローカルVaultに保存する | E-11 | ○ |
| C-10 | 各コピー時にnoteメッセージを出力する | E-11 | ○ |
| C-11 | 復号エラーがあっても他のシークレットのコピーは継続する | E-09, E-10 | ○ |
| C-12 | 復号エラーがある場合に戻り値1を返す | E-12 | ○ |
| C-13 | 正常時の戻り値が0である | E-12 | ○ |
| C-14 | ローカルVault無効時のエラーメッセージが正しい | E-04 | ○ |
| C-15 | データベース操作は行わない | E-01〜E-12（DB操作コード不在） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] --forceオプションの有無によるスキップロジックの記述が正しいか確認
- [ ] 部分成功（hadErrors）時の挙動の記述が正しいか確認
- [ ] 警告メッセージの文言がソースコードと一致しているか確認
