---
generated_at: 2026-02-04 10:03:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-secrets_encrypt-from-local.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsEncryptFromLocalCommand.php` 27行目 - AsCommandアトリビュート
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsEncryptFromLocalCommand.php` 30-35行目 - コンストラクタ
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsEncryptFromLocalCommand.php` 39-47行目 - configure（パラメータなし）
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsEncryptFromLocalCommand.php` 53-57行目 - ローカルVault有効性チェック
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsEncryptFromLocalCommand.php` 59行目 - vault->list(true)
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsEncryptFromLocalCommand.php` 60行目 - localVault->reveal(name)
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsEncryptFromLocalCommand.php` 60-61行目 - null判定スキップ
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsEncryptFromLocalCommand.php` 64行目 - 値の比較
- E-09: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsEncryptFromLocalCommand.php` 65行目 - vault->seal(name, localValue)
- E-10: `src/Symfony/Bundle/FrameworkBundle/Command/SecretsEncryptFromLocalCommand.php` 66行目 - note出力

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が secrets:encrypt-from-local である | E-01 | ○ |
| C-02 | 入力パラメータがない | E-03 | ○ |
| C-03 | ローカルVaultがnullの場合にエラーを返す | E-04 | ○ |
| C-04 | メインVaultから全シークレットを復号付きで取得する | E-05 | ○ |
| C-05 | localVault->revealでローカル値を取得する | E-06 | ○ |
| C-06 | ローカル値がnullの場合はスキップする | E-07 | ○ |
| C-07 | メイン値とローカル値が異なる場合のみsealする | E-08, E-09 | ○ |
| C-08 | 更新時にnoteメッセージを出力する | E-10 | ○ |
| C-09 | 正常時の戻り値が0である | E-05〜E-10 | ○ |
| C-10 | ローカルVault無効時のエラーメッセージが「The local vault is disabled.」 | E-04 | ○ |
| C-11 | メインVaultを基準にイテレーションする | E-05 | ○ |
| C-12 | データベース操作は行わない | E-01〜E-10（DB操作コード不在） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 差分比較ロジック（値が異なる場合のみ更新）の記述が正しいか確認
- [ ] ローカルVaultにのみ存在するシークレットの扱いが正しく記述されているか確認
- [ ] 戻り値が常に0である点（ローカルVault無効時を除く）の記述が正しいか確認
