---
generated_at: 2026-02-04 10:04:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：15-debug_config.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **AbstractConfigCommand親クラスのメソッド**：親クラスのソースコードを直接確認していないため根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 39行目 - AsCommandアトリビュート
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 45-50行目 - 入力パラメータ定義
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 40行目 - AbstractConfigCommand継承
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 78-86行目 - name引数null時の一覧表示
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 88-90行目 - findExtension, compileContainer
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 92行目 - getConfig呼び出し
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 96-100行目 - Yamlコンポーネント未インストールエラー
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 102-116行目 - path引数の処理
- E-09: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 133-140行目 - convertToFormat（txt/yaml/json）
- E-10: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 142-152行目 - compileContainerメソッド
- E-11: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 159-172行目 - getConfigForPathメソッド
- E-12: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 248-255行目 - getConfigメソッド（resolveEnvPlaceholders）
- E-13: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 272-275行目 - getAvailableFormatOptions
- E-14: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 203-224行目 - complete メソッド（シェル補完）
- E-15: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDebugCommand.php` 277-286行目 - getDocUrlメソッド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が debug:config である | E-01 | ○ |
| C-02 | name引数はオプションである | E-02 | ○ |
| C-03 | path引数はオプションである | E-02 | ○ |
| C-04 | --resolve-envオプションで環境変数を解決できる | E-02, E-12 | ○ |
| C-05 | --formatオプションでtxt/yaml/jsonを選択できる | E-02, E-09, E-13 | ○ |
| C-06 | name引数なしの場合にバンドル一覧を表示する | E-04 | ○ |
| C-07 | AbstractConfigCommandを継承している | E-03 | ○ |
| C-08 | findExtension/listBundles/listNonBundleExtensionsは親クラスで定義 | E-03 | △ |
| C-09 | カーネルをクローンしてDIコンテナをビルドする | E-10 | ○ |
| C-10 | ValidateEnvPlaceholdersPassから設定を取得する | E-06, E-12 | ○ |
| C-11 | パスが存在しない場合にLogicExceptionを投げる | E-11 | ○ |
| C-12 | Yamlコンポーネント未インストール時にエラーを返す | E-07 | ○ |
| C-13 | txt/yaml形式はYaml::dumpで出力する | E-09 | ○ |
| C-14 | json形式はjson_encodeで出力する | E-09 | ○ |
| C-15 | シェル補完機能がname, path, formatに対応する | E-14 | ○ |
| C-16 | ドキュメントURLが存在する場合にコメント出力する | E-15 | ○ |
| C-17 | データベース操作は行わない | E-01〜E-15（DB操作コード不在） | ○ |
| C-18 | 戻り値0で正常終了する | E-04, E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- AbstractConfigCommandの親クラス実装を直接読み取っていない
  - 候補：`src/Symfony/Bundle/FrameworkBundle/Command/AbstractConfigCommand.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 親クラスの記述1件のみが根拠不足だが、継承関係はソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] AbstractConfigCommandの親クラスメソッド（findExtension, listBundles等）の記述が正しいか確認
- [ ] 出力フォーマットの変換ロジックの記述が正しいか確認
- [ ] 環境変数プレースホルダ解決の挙動が正しく記述されているか確認
