---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：16-debug_container.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **BuildDebugContainerTrait**：トレイトのソースコードを直接確認していないため根拠不足
  2. **DescriptorHelperの対応フォーマット**：DescriptorHelperのソースコードを直接確認していないため根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` 36行目 - AsCommandアトリビュート
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` 39行目 - BuildDebugContainerTrait使用
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` 44-57行目 - 全入力パラメータ定義
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` 112-204行目 - execute メソッド
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` 248-265行目 - validateInput メソッド
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` 267-287行目 - findProperServiceName メソッド
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` 289-307行目 - findProperTagName メソッド
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` 309-329行目 - findServiceIdsContaining メソッド
- E-09: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` 185-191行目 - ServiceNotFoundException処理
- E-10: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` 167-184行目 - 非推奨・削除済みサービスの表示
- E-11: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` 193-201行目 - インタラクティブモードのヒント
- E-12: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerDebugCommand.php` 347-360行目 - filterToServiceTypes メソッド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が debug:container である | E-01 | ○ |
| C-02 | 12個の入力オプション/引数がある | E-03 | ○ |
| C-03 | BuildDebugContainerTraitでコンテナビルダーを取得する | E-02 | △ |
| C-04 | オプションの排他バリデーションを行う | E-05 | ○ |
| C-05 | 環境変数一覧/特定環境変数の表示モードがある | E-04 | ○ |
| C-06 | オートワイヤリング型フィルタ表示モードがある | E-04, E-12 | ○ |
| C-07 | パラメータ一覧/特定パラメータ表示モードがある | E-04 | ○ |
| C-08 | タグ別グループ/特定タグ表示モードがある | E-04 | ○ |
| C-09 | 特定サービス詳細表示モードがある | E-04 | ○ |
| C-10 | 非推奨情報表示モードがある | E-04 | ○ |
| C-11 | DescriptorHelperで出力する | E-04 | ○ |
| C-12 | DescriptorHelperがtxt/json/xml/md等に対応する | **根拠なし** | △ |
| C-13 | サービス名の部分一致検索に対応する | E-06, E-08 | ○ |
| C-14 | タグ名の部分一致検索に対応する | E-07 | ○ |
| C-15 | インタラクティブモードで候補選択が可能 | E-06, E-07 | ○ |
| C-16 | @始まりIDのServiceNotFoundException処理がある | E-09 | ○ |
| C-17 | 非推奨サービスの警告を表示する | E-10 | ○ |
| C-18 | 削除/インライン化されたサービスの注記を表示する | E-10 | ○ |
| C-19 | ドット始まりとcontainer.excludedタグ付きサービスが非表示 | E-08 | ○ |
| C-20 | データベース操作は行わない | E-01〜E-12（DB操作コード不在） | ○ |

## 4) 不足情報（Unknown / Missing）
- BuildDebugContainerTraitの実装詳細
  - 候補：`src/Symfony/Bundle/FrameworkBundle/Command/BuildDebugContainerTrait.php`
- DescriptorHelperの対応フォーマット一覧
  - 候補：`src/Symfony/Bundle/FrameworkBundle/Console/Helper/DescriptorHelper.php`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 外部クラス（DescriptorHelper, BuildDebugContainerTrait）の挙動に関する記述が一部根拠不足

## 6) レビュアーチェックリスト（最小）
- [ ] BuildDebugContainerTraitの挙動がドキュメントの記述と一致しているか確認
- [ ] DescriptorHelperの対応フォーマット（txt/json/xml/md）が正しいか確認
- [ ] 入力バリデーションの排他ルールの記述が正しいか確認
- [ ] 各表示モードの動作説明がソースコードと一致しているか確認
