---
generated_at: 2026-02-04 10:06:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：17-debug_autowiring.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **Descriptor::getClassDescription**：外部クラスのメソッドであり、ソースコードを直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 32行目 - AsCommandアトリビュート
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 33行目 - ContainerDebugCommand継承
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 37行目 - FileLinkFormatter依存
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 46-47行目 - search引数と--allオプション
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 69-71行目 - コンテナビルドとフィルタリング
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 73-83行目 - 検索フィルタリングロジック
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 85-91行目 - 逆エイリアスマップ構築
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 93行目 - 自然順ソート
- E-09: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 104-106行目 - container.excludedスキップ
- E-10: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 121-125行目 - ファイルリンク生成
- E-11: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 127-155行目 - エイリアス・ターゲット・非推奨情報
- E-12: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 156-158行目 - --allなし時の非表示カウント
- E-13: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 168-173行目 - 非表示数・ヒント表示
- E-14: `src/Symfony/Bundle/FrameworkBundle/Command/DebugAutowiringCommand.php` 190-196行目 - シェル補完

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が debug:autowiring である | E-01 | ○ |
| C-02 | ContainerDebugCommandを継承している | E-02 | ○ |
| C-03 | search引数でフィルタリングできる | E-04, E-06 | ○ |
| C-04 | --allオプションで非エイリアスサービスも表示できる | E-04, E-12 | ○ |
| C-05 | filterToServiceTypesで型名フィルタリングする | E-05 | ○ |
| C-06 | 検索文字列の正規化（非英数字除去）を行う | E-06 | ○ |
| C-07 | 部分一致・大文字小文字無視で検索する | E-06 | ○ |
| C-08 | 逆エイリアスマップをドット始まりIDで構築する | E-07 | ○ |
| C-09 | 自然順ソートを使用する | E-08 | ○ |
| C-10 | container.excludedタグ付きサービスをスキップする | E-09 | ○ |
| C-11 | FileLinkFormatterでファイルリンクを生成する | E-03, E-10 | ○ |
| C-12 | エイリアス・ターゲット・非推奨情報を表示する | E-11 | ○ |
| C-13 | Descriptor::getClassDescriptionでクラス説明を取得する | E-11 | △ |
| C-14 | --allなし時に非表示サービス数を表示する | E-12, E-13 | ○ |
| C-15 | --all時にインターフェース推奨ヒントを表示する | E-13 | ○ |
| C-16 | 検索結果なし時にエラーを返す | E-06 | ○ |
| C-17 | シェル補完で型名候補が表示される | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- Descriptor::getClassDescriptionメソッドの実装詳細
  - 候補：`src/Symfony/Bundle/FrameworkBundle/Console/Descriptor/Descriptor.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 外部クラスメソッドの記述1件のみが根拠不足

## 6) レビュアーチェックリスト（最小）
- [ ] 検索フィルタリングの正規化ロジックの記述が正しいか確認
- [ ] エイリアス・ターゲット・デコレータの表示ロジックが正しく記述されているか確認
- [ ] --allオプションの挙動の記述が正しいか確認
