---
generated_at: 2026-02-04 10:07:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：18-debug_event-dispatcher.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **DescriptorHelperの対応フォーマット**：DescriptorHelperのソースコードを直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` 35行目 - AsCommandアトリビュート
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` 38行目 - DEFAULT_DISPATCHER定数
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` 40-43行目 - コンストラクタ（ContainerInterface dispatchers）
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` 49-54行目 - 入力パラメータ定義
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` 80-85行目 - ディスパッチャー存在チェック
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` 89-104行目 - イベント名解決ロジック
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` 96-98行目 - 0件時の警告メッセージ
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` 109-111行目 - dispatcher_service_name設定
- E-09: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` 113-116行目 - DescriptorHelper出力
- E-10: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` 146-157行目 - searchForEventメソッド
- E-11: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` 121-144行目 - シェル補完（event, dispatcher, format）
- E-12: `src/Symfony/Bundle/FrameworkBundle/Command/EventDispatcherDebugCommand.php` 133-136行目 - ServiceProviderInterfaceチェック

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が debug:event-dispatcher である | E-01 | ○ |
| C-02 | デフォルトディスパッチャーが event_dispatcher である | E-02 | ○ |
| C-03 | event引数がオプションである | E-04 | ○ |
| C-04 | --dispatcherオプションでディスパッチャーを切り替えられる | E-04, E-05 | ○ |
| C-05 | --formatオプションで出力フォーマットを選択できる | E-04, E-09 | ○ |
| C-06 | ディスパッチャー不在時にエラーを返す | E-05 | ○ |
| C-07 | 直接一致と部分一致検索に対応する | E-06 | ○ |
| C-08 | 部分一致0件時に警告メッセージを表示し正常終了する | E-07 | ○ |
| C-09 | 部分一致1件時はそのイベントを対象にする | E-06 | ○ |
| C-10 | 部分一致複数件時は複数イベント一覧として設定する | E-06 | ○ |
| C-11 | デフォルト以外のディスパッチャー時にdispatcher_service_nameを含める | E-08 | ○ |
| C-12 | 部分一致検索はstrtolowerで大文字小文字無視 | E-10 | ○ |
| C-13 | DescriptorHelperがtxt/json/xml/md等に対応する | **根拠なし** | △ |
| C-14 | ServiceProviderInterface経由でディスパッチャー候補を取得する | E-12 | ○ |
| C-15 | シェル補完が event, dispatcher, format に対応する | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- DescriptorHelperの対応フォーマット一覧
  - 候補：`src/Symfony/Bundle/FrameworkBundle/Console/Helper/DescriptorHelper.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 外部クラスの対応フォーマット1件のみが根拠不足

## 6) レビュアーチェックリスト（最小）
- [ ] 部分一致検索の結果件数による分岐の記述が正しいか確認
- [ ] ディスパッチャー不在時のエラーコードが1であることを確認
- [ ] DescriptorHelperの対応フォーマットを確認
