---
generated_at: 2026-02-04 10:08:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-debug_router.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **DescriptorHelperの対応フォーマット**：DescriptorHelperのソースコードを直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 37行目 - AsCommandアトリビュート
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 40行目 - BuildDebugContainerTrait使用
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 42-45行目 - コンストラクタ（RouterInterface, FileLinkFormatter）
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 52-59行目 - 入力パラメータ定義
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 79-82行目 - RouteCollection取得、メソッド取得
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 83-86行目 - FileLinkFormatter時のコンテナ遅延ロード
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 88-113行目 - ルート名指定時の処理ロジック
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 92-103行目 - 非インタラクティブ+複数一致の処理
- E-09: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 105-109行目 - choice選択ロジック
- E-10: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 111-113行目 - ルート未検出時のInvalidArgumentException
- E-11: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 122-132行目 - 全ルート一覧表示
- E-12: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 137-147行目 - findRouteNameContainingメソッド
- E-13: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 149-160行目 - シェル補完
- E-14: `src/Symfony/Bundle/FrameworkBundle/Command/RouterDebugCommand.php` 162-172行目 - findRouteContainingメソッド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が debug:router である | E-01 | ○ |
| C-02 | RouterInterfaceとFileLinkFormatterを依存として受け取る | E-03 | ○ |
| C-03 | name引数がオプションである | E-04 | ○ |
| C-04 | --show-controllers, --show-aliases, --format, --raw, --method オプションがある | E-04 | ○ |
| C-05 | RouteCollectionを取得してルート情報を表示する | E-05 | ○ |
| C-06 | FileLinkFormatter設定時にコンテナビルダーを遅延ロードする | E-06 | ○ |
| C-07 | 完全一致と部分一致の両方でルートを検索する | E-07 | ○ |
| C-08 | 非インタラクティブ+完全一致なし+複数一致時に一覧を表示する | E-08 | ○ |
| C-09 | 部分一致1件時は自動選択する | E-09 | ○ |
| C-10 | 部分一致複数件時はchoiceで選択する | E-09 | ○ |
| C-11 | ルート未検出時にInvalidArgumentExceptionを投げる | E-10 | ○ |
| C-12 | 部分一致検索はstriposで大文字小文字無視 | E-12 | ○ |
| C-13 | --methodオプションで部分一致検索時にHTTPメソッドフィルタが適用される | E-12 | ○ |
| C-14 | DescriptorHelperがtxt/json/xml/md等に対応する | **根拠なし** | △ |
| C-15 | シェル補完がname, formatに対応する | E-13 | ○ |
| C-16 | BuildDebugContainerTraitを使用している | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- DescriptorHelperの対応フォーマット一覧
  - 候補：`src/Symfony/Bundle/FrameworkBundle/Console/Helper/DescriptorHelper.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 外部クラスの対応フォーマット1件のみが根拠不足

## 6) レビュアーチェックリスト（最小）
- [ ] ルート名検索のロジック（完全一致→部分一致→choice/例外）の記述が正しいか確認
- [ ] --methodオプションのフィルタリングロジックが正しいか確認
- [ ] DescriptorHelperの対応フォーマットを確認
