---
generated_at: 2026-02-04 10:09:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-debug_translation.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 42行目 - AsCommandアトリビュート
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 45-48行目 - 終了コード定数定義
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 49-51行目 - メッセージ状態定数
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 53-65行目 - コンストラクタ（依存注入）
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 70-77行目 - 入力パラメータ定義
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 125-127行目 - 翻訳パスとコードパスの取得
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 129-158行目 - バンドル/ディレクトリ/--all処理
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 161行目 - ExtractorInterface::extractによるキー抽出
- E-09: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 164行目 - TranslationReaderInterface::readによるメッセージ読み込み
- E-10: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 167-171行目 - MergeOperationによるマージ
- E-11: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 174-183行目 - メッセージなし時のEXIT_CODE_GENERAL_ERROR
- E-12: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 187行目 - フォールバックカタログ読み込み
- E-13: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 196-215行目 - メッセージ状態判定（missing/unused）
- E-14: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 217-221行目 - --only-missing/--only-unusedフィルタ
- E-15: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 223-231行目 - fallback判定
- E-16: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 242行目 - テーブル出力
- E-17: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 317-330行目 - sanitizeStringメソッド（40文字切り詰め）
- E-18: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 359-379行目 - loadFallbackCataloguesメソッド
- E-19: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 247-283行目 - シェル補完
- E-20: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 381-389行目 - getRootTransPathsメソッド
- E-21: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 391-400行目 - getRootCodePathsメソッド
- E-22: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationDebugCommand.php` 133-134行目 - Resources/translationsとtranslationsの両パス対応

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が debug:translation である | E-01 | ○ |
| C-02 | locale引数が必須（REQUIRED）である | E-05 | ○ |
| C-03 | bundle引数がオプションである | E-05 | ○ |
| C-04 | --domain, --only-missing, --only-unused, --all オプションがある | E-05 | ○ |
| C-05 | 終了コードがビットOR構成（0, 64, 65, 66, 68） | E-02 | ○ |
| C-06 | メッセージ状態定数（MISSING=0, UNUSED=1, EQUALS_FALLBACK=2） | E-03 | ○ |
| C-07 | TranslatorInterface, TranslationReaderInterface, ExtractorInterfaceに依存する | E-04 | ○ |
| C-08 | バンドル名解決とディレクトリパスフォールバックに対応する | E-07 | ○ |
| C-09 | --allオプションで全バンドル対象にする | E-07 | ○ |
| C-10 | ExtractorInterfaceでテンプレートから翻訳キーを抽出する | E-08 | ○ |
| C-11 | TranslationReaderInterfaceで翻訳ファイルを読み込む | E-09 | ○ |
| C-12 | MergeOperationでカタログをマージする | E-10 | ○ |
| C-13 | メッセージなし時にEXIT_CODE_GENERAL_ERROR (64) を返す | E-11 | ○ |
| C-14 | フォールバックロケールのカタログを読み込む | E-12, E-18 | ○ |
| C-15 | Translator/DataCollectorTranslator/LoggingTranslatorのフォールバックに対応する | E-18 | ○ |
| C-16 | missing/unused/fallbackの状態判定を行う | E-13, E-15 | ○ |
| C-17 | --only-missing/--only-unusedで表示フィルタを行う | E-14 | ○ |
| C-18 | テーブル形式で結果を出力する | E-16 | ○ |
| C-19 | メッセージプレビューは40文字にサニタイズされる | E-17 | ○ |
| C-20 | シェル補完がlocale, bundle, domainに対応する | E-19 | ○ |
| C-21 | バンドルの新旧両パス（Resources/translations, translations）に対応する | E-22 | ○ |
| C-22 | バンドル指定時にdefaultTransPath, defaultViewsPathも追加される | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 終了コードのビットOR構成が正しく記述されているか確認
- [ ] メッセージ状態判定ロジックの記述がソースコードと一致しているか確認
- [ ] --only-missing/--only-unusedの終了コードへの影響の記述が正しいか確認
- [ ] フォールバックカタログの読み込みロジックが正しいか確認
