---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：21-router_match.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/RouterMatchCommand.php`（ソースコード全体）
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/RouterMatchCommand.php` L33（AsCommand属性定義）
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/RouterMatchCommand.php` L46-67（configure メソッド）
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/RouterMatchCommand.php` L69-116（execute メソッド）
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/RouterMatchCommand.php` L39-44（コンストラクタ）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L22（No.21エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `router:match` である | E-02 | ○ |
| C-02 | path_infoは必須引数である | E-03（InputArgument::REQUIRED） | ○ |
| C-03 | method, scheme, hostはオプションパラメータである | E-03（InputOption定義） | ○ |
| C-04 | TraceableUrlMatcherを使用してマッチングをトレースする | E-04 L84 | ○ |
| C-05 | ExpressionLanguageプロバイダーをマッチャーに追加する | E-04 L85-87 | ○ |
| C-06 | ROUTE_ALMOST_MATCHES時に部分一致情報を表示する | E-04 L95-96 | ○ |
| C-07 | ROUTE_MATCHES時にdebug:routerコマンドを内部呼び出しする | E-04 L100-101 | ○ |
| C-08 | マッチなし時に終了コード1を返す | E-04 L109-113 | ○ |
| C-09 | マッチあり時に終了コード0を返す | E-04 L115 | ○ |
| C-10 | verbose時に不一致理由を表示する | E-04 L104-106 | ○ |
| C-11 | RouterInterfaceをコンストラクタで受け取る | E-05 | ○ |
| C-12 | カテゴリは「FrameworkBundle - ルーティング」である | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張がソースコードに基づいている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] TraceableUrlMatcherの動作仕様がSymfony公式ドキュメントと一致しているか
- [ ] debug:routerコマンドとの連携が正しく記述されているか
