---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-config_dump-reference.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDumpReferenceCommand.php`（ソースコード全体）
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDumpReferenceCommand.php` L38（AsCommand属性定義）
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDumpReferenceCommand.php` L41-69（configure メソッド）
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDumpReferenceCommand.php` L74-148（execute メソッド）
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/ConfigDumpReferenceCommand.php` L186-189（getAvailableFormatOptions）
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/AbstractConfigCommand.php`（基底クラス）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L23（No.22エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `config:dump-reference` である | E-02 | ○ |
| C-02 | AbstractConfigCommandを継承している | E-01 L39 | ○ |
| C-03 | name引数はオプショナルである | E-03（InputArgument::OPTIONAL） | ○ |
| C-04 | path引数はオプショナルである | E-03 | ○ |
| C-05 | format オプションのデフォルト値はyamlである | E-03 L47 | ○ |
| C-06 | サポートフォーマットはyamlとxmlである | E-05 | ○ |
| C-07 | name未指定時にバンドルリストを表示する | E-04 L79-89 | ○ |
| C-08 | pathオプションはyaml形式のみ対応 | E-04 L111-115 | ○ |
| C-09 | YamlReferenceDumperを使用する | E-04 L134 | ○ |
| C-10 | XmlReferenceDumperを使用する | E-04 L138 | ○ |
| C-11 | Yamlクラス未存在時にエラーを返す | E-04 L103-107 | ○ |
| C-12 | docUrl属性が出力に含まれる | E-04 L127-129, E-01 L191-203 | ○ |
| C-13 | オートコンプリート機能を持つ | E-01 L150-160 | ○ |
| C-14 | カテゴリは「FrameworkBundle - 設定」である | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張がソースコードに基づいている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] AbstractConfigCommandの共有ロジック（findExtension等）が正しく記述されているか
- [ ] サポートフォーマットの一覧が最新の実装と一致しているか
