---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-assets_install.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/AssetsInstallCommand.php`（ソースコード全体）
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/AssetsInstallCommand.php` L36（AsCommand属性定義）
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/AssetsInstallCommand.php` L50-80（configure メソッド）
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/AssetsInstallCommand.php` L82-181（execute メソッド）
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/AssetsInstallCommand.php` L188-216（symlink関連メソッド）
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/AssetsInstallCommand.php` L238-245（hardCopy メソッド）
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/AssetsInstallCommand.php` L247-264（getPublicDirectory メソッド）
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/AssetsInstallCommand.php` L39-41（METHOD定数）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L24（No.23エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `assets:install` である | E-02 | ○ |
| C-02 | 3つのインストール方法（copy, absolute symlink, relative symlink）がある | E-08 | ○ |
| C-03 | target引数はオプショナルである | E-03 | ○ |
| C-04 | --symlink, --relative, --no-cleanup オプションがある | E-03 L56-58 | ○ |
| C-05 | Resources/publicまたはpublicディレクトリを確認する | E-04 L122 | ○ |
| C-06 | バンドル名から"bundle"を除去した小文字名でディレクトリを作成 | E-04 L126 | ○ |
| C-07 | シンボリックリンク失敗時にフォールバックする | E-05 L188-216 | ○ |
| C-08 | --no-cleanup未指定時に不要アセットを削除する | E-04 L162-165 | ○ |
| C-09 | Finderを使用してVCSファイルを含めてコピーする | E-06 L242 | ○ |
| C-10 | composer.jsonからpublicディレクトリを検出する | E-07 | ○ |
| C-11 | ターゲットディレクトリ未存在時にInvalidArgumentException | E-04 L94-97 | ○ |
| C-12 | 結果をテーブル形式で表示する | E-04 L168 | ○ |
| C-13 | Filesystemコンポーネントを使用する | E-01 L43-44 | ○ |
| C-14 | コピーフォールバック時に注意メッセージを表示する | E-04 L174-176 | ○ |
| C-15 | カテゴリは「FrameworkBundle - アセット」である | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張がソースコードに基づいている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] フォールバック機構の動作フローが正確に記述されているか
- [ ] publicディレクトリの自動検出ロジックが正しいか
