---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-translation_extract.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationExtractCommand.php`（ソースコード全体）
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationExtractCommand.php` L39（AsCommand属性定義）
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationExtractCommand.php` L70-117（configure メソッド）
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationExtractCommand.php` L119-291（execute メソッド）
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationExtractCommand.php` L42-48（定数定義 FORMATS, SORT_ORDERS）
- E-06: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationExtractCommand.php` L347-378（filterCatalogue メソッド）
- E-07: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationExtractCommand.php` L428-440（extractMessages メソッド）
- E-08: `src/Symfony/Bundle/FrameworkBundle/Command/TranslationExtractCommand.php` L496-503（removeNoFillTranslations メソッド）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L25（No.24エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `translation:extract` である | E-02 | ○ |
| C-02 | locale引数は必須である | E-03 L74（InputArgument::REQUIRED） | ○ |
| C-03 | --forceまたは--dump-messagesのいずれかが必須 | E-04 L125-129 | ○ |
| C-04 | xlf12, xlf20のフォーマットショートカットがある | E-05 L45-48 | ○ |
| C-05 | --cleanオプションでTargetOperationが使用される | E-04 L198-200 | ○ |
| C-06 | デフォルトではMergeOperationが使用される | E-04 L198-200 | ○ |
| C-07 | --no-fillオプションで翻訳値を空にする | E-08, E-04 L186 | ○ |
| C-08 | --sortオプションでasc/descソートが可能 | E-05 L43-44, E-04 L213-220 | ○ |
| C-09 | --domainオプションでドメインフィルタリングが可能 | E-04 L192-195, E-06 | ○ |
| C-10 | --as-treeオプションでツリー形式出力が可能 | E-03 L84 | ○ |
| C-11 | Intlドメインへの自動移行を行う | E-04 L211 | ○ |
| C-12 | 重複翻訳パスのフィルタリングを行う | E-01 L442-461 | ○ |
| C-13 | 新規キーは緑、不要キーは赤で表示される | E-04 L230-233 | ○ |
| C-14 | defaultLocaleをコンストラクタで受け取る | E-01 L55 | ○ |
| C-15 | bundle引数でバンドルまたはディレクトリパスを指定可能 | E-04 L156-180 | ○ |
| C-16 | カテゴリは「FrameworkBundle - 翻訳」である | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張がソースコードに基づいている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] MergeOperationとTargetOperationの動作の違いが正しく記述されているか
- [ ] XLIFF 1.2/2.0のフォーマット切り替えロジックが正確か
- [ ] --no-fillオプションと--prefixオプションの排他関係が正しいか
