---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-lint_container.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerLintCommand.php`（ソースコード全体）
- E-02: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerLintCommand.php` L31（AsCommand属性定義）
- E-03: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerLintCommand.php` L36-42（configure メソッド）
- E-04: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerLintCommand.php` L44-72（execute メソッド）
- E-05: `src/Symfony/Bundle/FrameworkBundle/Command/ContainerLintCommand.php` L74-124（getContainerBuilder メソッド）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L26（No.25エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `lint:container` である | E-02 | ○ |
| C-02 | finalクラスとして宣言されている | E-01 L32 | ○ |
| C-03 | --resolve-env-varsオプションがある | E-03 L40 | ○ |
| C-04 | 成功時に終了コード0を返す | E-04 L71 | ○ |
| C-05 | InvalidArgumentException時に終了コード1を返す | E-04 L63-67 | ○ |
| C-06 | RuntimeException時に終了コード2を返す | E-04 L53-57 | ○ |
| C-07 | キャッシュファイルからContainerBuilderを復元する | E-05 L82-96 | ○ |
| C-08 | Kernelクラス非継承時にRuntimeExceptionをスロー | E-05 L85-87 | ○ |
| C-09 | CheckTypeDeclarationsPassをコンパイラパスに追加 | E-05 L121 | ○ |
| C-10 | CheckAliasValidityPassをコンパイラパスに追加 | E-05 L120 | ○ |
| C-11 | container.runtime_modeをweb=0に設定 | E-05 L118 | ○ |
| C-12 | resolve-env-vars時にResolveParameterPlaceHoldersPassを使用 | E-05 L103 | ○ |
| C-13 | カテゴリは「FrameworkBundle - リント」である | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張がソースコードに基づいている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] コンテナ取得フローの2パターン（キャッシュ/再構築）が正確に記述されているか
- [ ] コンパイラパスの追加順序と優先度が正しいか
