---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-lint_xliff.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Translation/Command/XliffLintCommand.php`（ソースコード全体）
- E-02: `src/Symfony/Component/Translation/Command/XliffLintCommand.php` L35（AsCommand属性定義）
- E-03: `src/Symfony/Component/Translation/Command/XliffLintCommand.php` L55-83（configure メソッド）
- E-04: `src/Symfony/Component/Translation/Command/XliffLintCommand.php` L85-112（execute メソッド）
- E-05: `src/Symfony/Component/Translation/Command/XliffLintCommand.php` L114-157（validate メソッド）
- E-06: `src/Symfony/Component/Translation/Command/XliffLintCommand.php` L159-167（display メソッド）
- E-07: `src/Symfony/Component/Translation/Command/XliffLintCommand.php` L220-235（getFiles メソッド）
- E-08: `src/Symfony/Component/Translation/Command/XliffLintCommand.php` L265-275（getTargetLanguageFromFile メソッド）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L27（No.26エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `lint:xliff` である | E-02 | ○ |
| C-02 | filename引数は配列型で複数指定可能 | E-03 L58 | ○ |
| C-03 | 出力フォーマットはtxt, json, githubの3種類 | E-01 L284-287 | ○ |
| C-04 | GitHub Actions環境で自動的にgithubフォーマットが選択される | E-04 L89 | ○ |
| C-05 | STDINからの入力に対応（"-"指定） | E-04 L92-94 | ○ |
| C-06 | .xlf, .xliff拡張子のファイルを対象とする | E-07 L229 | ○ |
| C-07 | DOMDocumentでXMLをパースする | E-05 L125-126 | ○ |
| C-08 | target-language属性とファイル名の一致を検証する | E-05 L128-143, E-08 | ○ |
| C-09 | XliffUtils::validateSchemaでスキーマ検証を行う | E-05 L145-151 | ○ |
| C-10 | 空ファイルはvalidとして処理する | E-05 L119-121 | ○ |
| C-11 | requireStrictFileNamesフラグでパターン厳密さを制御 | E-05 L134, E-01 L47 | ○ |
| C-12 | カスタムディレクトリイテレータプロバイダーを注入可能 | E-01 L43-52 | ○ |
| C-13 | エラー情報に行番号・カラム番号を含む | E-05 L137-141, L147-150 | ○ |
| C-14 | 基盤実装パスが正しい | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張がソースコードに基づいている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] XliffUtils::validateSchemaの具体的な検証内容が妥当か（外部クラス参照）
- [ ] target-language属性のマッチングロジックが正確に記述されているか
